/*
 * Decompiled with CFR 0.152.
 */
package com.okta.spring.boot.oauth;

import com.okta.spring.boot.oauth.AuthoritiesProvider;
import com.okta.spring.boot.oauth.AuthorityProvidersConfig;
import com.okta.spring.boot.oauth.ConditionalOnOktaClientProperties;
import com.okta.spring.boot.oauth.ReactiveOktaOAuth2UserService;
import com.okta.spring.boot.oauth.ReactiveOktaOidcUserService;
import com.okta.spring.boot.oauth.config.OktaOAuth2Properties;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.security.reactive.ReactiveSecurityAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.security.config.annotation.web.reactive.EnableWebFluxSecurity;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcReactiveOAuth2UserService;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserRequest;
import org.springframework.security.oauth2.client.userinfo.ReactiveOAuth2UserService;
import org.springframework.security.oauth2.core.user.OAuth2User;
import reactor.core.publisher.Flux;

@Configuration
@AutoConfigureAfter(value={ReactiveSecurityAutoConfiguration.class})
@EnableConfigurationProperties(value={OktaOAuth2Properties.class})
@ConditionalOnOktaClientProperties
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
@ConditionalOnClass(value={Flux.class, EnableWebFluxSecurity.class, ClientRegistration.class})
@ConditionalOnBean(value={ReactiveSecurityAutoConfiguration.class})
@Import(value={AuthorityProvidersConfig.class})
class ReactiveOktaOAuth2AutoConfig {
    ReactiveOktaOAuth2AutoConfig() {
    }

    @Bean
    @ConditionalOnMissingBean
    ReactiveOAuth2UserService<OAuth2UserRequest, OAuth2User> oauth2UserService(Collection<AuthoritiesProvider> authoritiesProviders) {
        return new ReactiveOktaOAuth2UserService(authoritiesProviders);
    }

    @Bean
    @ConditionalOnMissingBean
    OidcReactiveOAuth2UserService oidcUserService(Collection<AuthoritiesProvider> authoritiesProviders, @Qualifier(value="oauth2UserService") ReactiveOAuth2UserService<OAuth2UserRequest, OAuth2User> oAuth2UserService) {
        return new ReactiveOktaOidcUserService(authoritiesProviders, oAuth2UserService);
    }
}

