/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.resource;

import com.okta.commons.lang.Collections;
import com.okta.sdk.impl.resource.HalResourceHrefResolver;
import com.okta.sdk.impl.resource.ResourceHrefResolver;
import com.okta.sdk.resource.Resource;
import com.okta.sdk.resource.application.AppUser;
import com.okta.sdk.resource.application.Application;
import com.okta.sdk.resource.group.Group;
import com.okta.sdk.resource.group.rule.GroupRule;
import com.okta.sdk.resource.user.Role;
import java.util.Map;

public class OktaResourceHrefResolver
implements ResourceHrefResolver {
    private final ResourceHrefResolver halResourceHrefResolver = new HalResourceHrefResolver();

    @Override
    public <R extends Resource> String resolveHref(Map<String, ?> properties, Class<R> clazz) {
        String href = this.halResourceHrefResolver.resolveHref(properties, clazz);
        return href != null ? href : this.fixSelfHref(properties, clazz);
    }

    private <R extends Resource> String fixSelfHref(Map<String, ?> properties, Class<R> clazz) {
        Map<String, ?> links = this.getMapValue(properties, "_links");
        if (links != null) {
            Map<String, ?> assignee;
            Map<String, ?> self;
            if (AppUser.class.isAssignableFrom(clazz) && !Collections.isEmpty(self = this.getMapValue(links, "app"))) {
                return self.get("href") + "/users/" + properties.get("id");
            }
            if (Application.class.isAssignableFrom(clazz) && !Collections.isEmpty(self = this.getMapValue(links, "users"))) {
                String href = self.get("href").toString();
                return href.substring(0, href.lastIndexOf("/users"));
            }
            if (Role.class.isAssignableFrom(clazz) && !Collections.isEmpty(assignee = this.getMapValue(links, "assignee"))) {
                String href = assignee.get("href").toString();
                return href + "/roles/" + properties.get("id");
            }
        }
        if (Group.class.isAssignableFrom(clazz)) {
            return "/api/v1/groups/" + properties.get("id");
        }
        if (GroupRule.class.isAssignableFrom(clazz)) {
            return "/api/v1/groups/rules/" + properties.get("id");
        }
        return null;
    }

    private Map<String, ?> getMapValue(Map<String, ?> properties, String key) {
        if (!Collections.isEmpty(properties)) {
            return (Map)properties.get(key);
        }
        return null;
    }
}

