/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.config;

import com.okta.commons.lang.Assert;
import com.okta.commons.lang.Collections;
import com.okta.sdk.impl.config.PropertiesSource;
import java.util.LinkedHashMap;
import java.util.Map;

public class FilteredPropertiesSource
implements PropertiesSource {
    private final PropertiesSource propertiesSource;
    private final Filter filter;

    public FilteredPropertiesSource(PropertiesSource propertiesSource, Filter filter) {
        Assert.notNull((Object)propertiesSource, (String)"source cannot be null.");
        Assert.notNull((Object)filter, (String)"filter cannot be null.");
        this.propertiesSource = propertiesSource;
        this.filter = filter;
    }

    @Override
    public Map<String, String> getProperties() {
        Map<String, String> props = this.propertiesSource.getProperties();
        LinkedHashMap<String, String> retained = new LinkedHashMap<String, String>();
        if (!Collections.isEmpty(props)) {
            props.forEach((key, value) -> {
                String[] evaluated = this.filter.map((String)key, (String)value);
                if (evaluated != null) {
                    Assert.isTrue((2 == evaluated.length ? 1 : 0) != 0, (String)"Filter returned string array must have a length of 2 (key/value pair)");
                    retained.put(evaluated[0], evaluated[1]);
                }
            });
        }
        return retained;
    }

    public static interface Filter {
        public String[] map(String var1, String var2);
    }
}

