/*
 * Okta API
 * Allows customers to easily access the Okta API
 *
 * OpenAPI spec version: 2.9.2
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.okta.sdk.impl.resource.user;

import com.okta.sdk.resource.role.RoleAssignmentType;
import com.okta.sdk.resource.role.RoleType;
import com.okta.sdk.resource.user.Role;
import com.okta.sdk.resource.user.RoleStatus;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


import com.okta.sdk.impl.resource.AbstractInstanceResource;
import com.okta.sdk.impl.resource.AbstractResource;
import com.okta.sdk.impl.resource.Property;
import com.okta.sdk.impl.resource.ResourceReference;
import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.commons.http.QueryString;
import com.okta.commons.http.HttpHeaders;

import com.okta.sdk.impl.resource.BooleanProperty;
import com.okta.sdk.impl.resource.IntegerProperty;
import com.okta.sdk.impl.resource.DoubleProperty;
import com.okta.sdk.impl.resource.StringProperty;
import com.okta.sdk.impl.resource.CharacterArrayProperty;
import com.okta.sdk.impl.resource.ListProperty;
import com.okta.sdk.impl.resource.EnumListProperty;
import com.okta.sdk.impl.resource.ResourceListProperty;
import com.okta.sdk.impl.resource.DateProperty;
import com.okta.sdk.impl.resource.EnumProperty;
import com.okta.sdk.impl.resource.MapProperty;
import com.okta.sdk.impl.resource.DefaultVoidResource;
import com.okta.sdk.impl.resource.DefaultFileResource;
import com.okta.sdk.resource.VoidResource;
import com.okta.sdk.resource.Resource;
import java.util.Map;
import java.util.HashMap;

import static com.okta.commons.lang.Assert.notNull;
import static com.okta.commons.lang.Assert.hasText;


/**
 * Role
 */
@javax.annotation.Generated(
        value = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
        date  = "2021-12-15T06:35:43.156-06:00")
public class DefaultRole extends AbstractInstanceResource<Role> implements Role {

    private final static MapProperty embeddedProperty = new MapProperty("_embedded");
    private final static MapProperty linksProperty = new MapProperty("_links");
    private final static EnumProperty<RoleAssignmentType> assignmentTypeProperty = new EnumProperty("assignmentType", RoleAssignmentType.class);
    private final static DateProperty createdProperty = new DateProperty("created");
    private final static StringProperty descriptionProperty = new StringProperty("description");
    private final static StringProperty idProperty = new StringProperty("id");
    private final static StringProperty labelProperty = new StringProperty("label");
    private final static DateProperty lastUpdatedProperty = new DateProperty("lastUpdated");
    private final static EnumProperty<RoleStatus> statusProperty = new EnumProperty("status", RoleStatus.class);
    private final static EnumProperty<RoleType> typeProperty = new EnumProperty("type", RoleType.class);

    private final static Map<String, Property> PROPERTY_DESCRIPTORS = createPropertyDescriptorMap(embeddedProperty, linksProperty, assignmentTypeProperty, createdProperty, descriptionProperty, idProperty, labelProperty, lastUpdatedProperty, statusProperty, typeProperty);

    public DefaultRole(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultRole(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    public Class<? extends Resource> getResourceClass() {
        return Role.class;
    }

    public Map<String, Object> getEmbedded() {
        return  getMap(embeddedProperty);
    }

    public Map<String, Object> getLinks() {
        return  getMap(linksProperty);
    }

    public RoleAssignmentType getAssignmentType() {
        return  getEnumProperty(assignmentTypeProperty);
    }

    public Role setAssignmentType(RoleAssignmentType assignmentType) {
        setProperty(assignmentTypeProperty, assignmentType);
        return this;
    }

    public Date getCreated() {
        return  getDateProperty(createdProperty);
    }

    public String getDescription() {
        return  getString(descriptionProperty);
    }

    public Role setDescription(String description) {
        setProperty(descriptionProperty, description);
        return this;
    }

    public String getId() {
        return  getString(idProperty);
    }

    public String getLabel() {
        return  getString(labelProperty);
    }

    public Date getLastUpdated() {
        return  getDateProperty(lastUpdatedProperty);
    }

    public RoleStatus getStatus() {
        return  getEnumProperty(statusProperty);
    }

    public RoleType getType() {
        return  getEnumProperty(typeProperty);
    }

    public Role setType(RoleType type) {
        setProperty(typeProperty, type);
        return this;
    }


    /**
    * 
    * 
    * @param targetGroupId  (required)
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2021-12-15T06:35:43.156-06:00",
          comments = "PUT - /api/v1/groups/{groupId}/roles/{roleId}/targets/groups/{targetGroupId}")
    public void addAdminGroupTarget(String targetGroupId) {

        String roleId = getId();
        Map<String, String> pathArgs = getParamsFromHref("/api/v1/groups/{groupId}/roles/{roleId}/targets/groups/{targetGroupId}");
        String groupId = pathArgs.get("groupId");

        hasText(groupId, "'groupId' is required and cannot be null or empty.");
        hasText(roleId, "'roleId' is required and cannot be null or empty.");
        hasText(targetGroupId, "'targetGroupId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();


        String href = "/api/v1/groups/" + groupId + "/roles/" + roleId + "/targets/groups/" + targetGroupId + "";
        getDataStore().save(href, new DefaultVoidResource(getDataStore()), this, queryArgs, headers);

    }




    /**
    * 
    * Success
    * @param appName  (required)
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2021-12-15T06:35:43.156-06:00",
          comments = "PUT - /api/v1/users/{userId}/roles/{roleId}/targets/catalog/apps/{appName}")
    public void addAppTargetToAdminRoleForUser(String appName) {

        String roleId = getId();
        Map<String, String> pathArgs = getParamsFromHref("/api/v1/users/{userId}/roles/{roleId}/targets/catalog/apps/{appName}");
        String userId = pathArgs.get("userId");

        hasText(userId, "'userId' is required and cannot be null or empty.");
        hasText(roleId, "'roleId' is required and cannot be null or empty.");
        hasText(appName, "'appName' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();


        String href = "/api/v1/users/" + userId + "/roles/" + roleId + "/targets/catalog/apps/" + appName + "";
        getDataStore().save(href, new DefaultVoidResource(getDataStore()), this, queryArgs, headers);

    }




    /**
    * Add App Instance Target to App Administrator Role given to a Group
    * Add App Instance Target to App Administrator Role given to a Group
    * @param appName  (required)
    * @param applicationId  (required)
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2021-12-15T06:35:43.156-06:00",
          comments = "PUT - /api/v1/groups/{groupId}/roles/{roleId}/targets/catalog/apps/{appName}/{applicationId}")
    public void addAppInstanceTargetToAdminRole(String appName, String applicationId) {

        String roleId = getId();
        Map<String, String> pathArgs = getParamsFromHref("/api/v1/groups/{groupId}/roles/{roleId}/targets/catalog/apps/{appName}/{applicationId}");
        String groupId = pathArgs.get("groupId");

        hasText(groupId, "'groupId' is required and cannot be null or empty.");
        hasText(roleId, "'roleId' is required and cannot be null or empty.");
        hasText(appName, "'appName' is required and cannot be null or empty.");
        hasText(applicationId, "'applicationId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();


        String href = "/api/v1/groups/" + groupId + "/roles/" + roleId + "/targets/catalog/apps/" + appName + "/" + applicationId + "";
        getDataStore().save(href, new DefaultVoidResource(getDataStore()), this, queryArgs, headers);

    }




    /**
    * Add App Instance Target to App Administrator Role given to a User
    * Add App Instance Target to App Administrator Role given to a User
    * @param appName  (required)
    * @param applicationId  (required)
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2021-12-15T06:35:43.156-06:00",
          comments = "PUT - /api/v1/users/{userId}/roles/{roleId}/targets/catalog/apps/{appName}/{applicationId}")
    public void addAppTargetToAppAdminRoleForUser(String appName, String applicationId) {

        String roleId = getId();
        Map<String, String> pathArgs = getParamsFromHref("/api/v1/users/{userId}/roles/{roleId}/targets/catalog/apps/{appName}/{applicationId}");
        String userId = pathArgs.get("userId");

        hasText(userId, "'userId' is required and cannot be null or empty.");
        hasText(roleId, "'roleId' is required and cannot be null or empty.");
        hasText(appName, "'appName' is required and cannot be null or empty.");
        hasText(applicationId, "'applicationId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();


        String href = "/api/v1/users/" + userId + "/roles/" + roleId + "/targets/catalog/apps/" + appName + "/" + applicationId + "";
        getDataStore().save(href, new DefaultVoidResource(getDataStore()), this, queryArgs, headers);

    }




    /**
    * 
    * Success
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2021-12-15T06:35:43.156-06:00",
          comments = "PUT - /api/v1/users/{userId}/roles/{roleId}/targets/catalog/apps")
    public void addAllAppsAsTargetToRole() {

        String roleId = getId();
        Map<String, String> pathArgs = getParamsFromHref("/api/v1/users/{userId}/roles/{roleId}/targets/catalog/apps");
        String userId = pathArgs.get("userId");

        hasText(userId, "'userId' is required and cannot be null or empty.");
        hasText(roleId, "'roleId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();


        String href = "/api/v1/users/" + userId + "/roles/" + roleId + "/targets/catalog/apps";
        getDataStore().save(href, new DefaultVoidResource(getDataStore()), this, queryArgs, headers);

    }




    /**
    * 
    * Success
    * @param appName  (required)
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2021-12-15T06:35:43.156-06:00",
          comments = "PUT - /api/v1/groups/{groupId}/roles/{roleId}/targets/catalog/apps/{appName}")
    public void addAppTargetToAdminRole(String appName) {

        String roleId = getId();
        Map<String, String> pathArgs = getParamsFromHref("/api/v1/groups/{groupId}/roles/{roleId}/targets/catalog/apps/{appName}");
        String groupId = pathArgs.get("groupId");

        hasText(groupId, "'groupId' is required and cannot be null or empty.");
        hasText(roleId, "'roleId' is required and cannot be null or empty.");
        hasText(appName, "'appName' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();


        String href = "/api/v1/groups/" + groupId + "/roles/" + roleId + "/targets/catalog/apps/" + appName + "";
        getDataStore().save(href, new DefaultVoidResource(getDataStore()), this, queryArgs, headers);

    }



}
