/*
 * Okta API
 * Allows customers to easily access the Okta API
 *
 * OpenAPI spec version: 2.9.2
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.okta.sdk.impl.resource.org;

import com.okta.sdk.resource.org.OrgOktaSupportSetting;
import com.okta.sdk.resource.org.OrgOktaSupportSettingsObj;
import java.util.Date;


import com.okta.sdk.impl.resource.AbstractInstanceResource;
import com.okta.sdk.impl.resource.AbstractResource;
import com.okta.sdk.impl.resource.Property;
import com.okta.sdk.impl.resource.ResourceReference;
import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.commons.http.QueryString;
import com.okta.commons.http.HttpHeaders;

import com.okta.sdk.impl.resource.BooleanProperty;
import com.okta.sdk.impl.resource.IntegerProperty;
import com.okta.sdk.impl.resource.DoubleProperty;
import com.okta.sdk.impl.resource.StringProperty;
import com.okta.sdk.impl.resource.CharacterArrayProperty;
import com.okta.sdk.impl.resource.ListProperty;
import com.okta.sdk.impl.resource.EnumListProperty;
import com.okta.sdk.impl.resource.ResourceListProperty;
import com.okta.sdk.impl.resource.DateProperty;
import com.okta.sdk.impl.resource.EnumProperty;
import com.okta.sdk.impl.resource.MapProperty;
import com.okta.sdk.impl.resource.DefaultVoidResource;
import com.okta.sdk.impl.resource.DefaultFileResource;
import com.okta.sdk.resource.VoidResource;
import com.okta.sdk.resource.Resource;
import java.util.Map;
import java.util.HashMap;

import static com.okta.commons.lang.Assert.notNull;
import static com.okta.commons.lang.Assert.hasText;


/**
 * OrgOktaSupportSettingsObj
 */
@javax.annotation.Generated(
        value = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
        date  = "2021-12-15T06:35:43.156-06:00")
public class DefaultOrgOktaSupportSettingsObj extends AbstractInstanceResource<OrgOktaSupportSettingsObj> implements OrgOktaSupportSettingsObj {

    private final static DateProperty expirationProperty = new DateProperty("expiration");
    private final static EnumProperty<OrgOktaSupportSetting> supportProperty = new EnumProperty("support", OrgOktaSupportSetting.class);

    private final static Map<String, Property> PROPERTY_DESCRIPTORS = createPropertyDescriptorMap(expirationProperty, supportProperty);

    public DefaultOrgOktaSupportSettingsObj(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultOrgOktaSupportSettingsObj(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    public Class<? extends Resource> getResourceClass() {
        return OrgOktaSupportSettingsObj.class;
    }

    public Date getExpiration() {
        return  getDateProperty(expirationProperty);
    }

    public OrgOktaSupportSetting getSupport() {
        return  getEnumProperty(supportProperty);
    }


    /**
    * Grant Okta Support
    * Enables you to temporarily allow Okta Support to access your org as an administrator for eight hours.
    * @return OrgOktaSupportSettingsObj
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2021-12-15T06:35:43.156-06:00",
          comments = "POST - /api/v1/org/privacy/oktaSupport/grant")
    public OrgOktaSupportSettingsObj grantOktaSupport() {




        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().create(
            "/api/v1/org/privacy/oktaSupport/grant",
            new DefaultVoidResource(getDataStore()),
            this,
            OrgOktaSupportSettingsObj.class,
            queryArgs,
            headers);

    }




    /**
    * Extend Okta Support
    * Extends the length of time that Okta Support can access your org by 24 hours. This means that 24 hours are added to the remaining access time.
    * @return OrgOktaSupportSettingsObj
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2021-12-15T06:35:43.156-06:00",
          comments = "POST - /api/v1/org/privacy/oktaSupport/extend")
    public OrgOktaSupportSettingsObj extendOktaSupport() {




        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().create(
            "/api/v1/org/privacy/oktaSupport/extend",
            new DefaultVoidResource(getDataStore()),
            this,
            OrgOktaSupportSettingsObj.class,
            queryArgs,
            headers);

    }




    /**
    * Extend Okta Support
    * Revokes Okta Support access to your organization.
    * @return OrgOktaSupportSettingsObj
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2021-12-15T06:35:43.156-06:00",
          comments = "POST - /api/v1/org/privacy/oktaSupport/revoke")
    public OrgOktaSupportSettingsObj revokeOktaSupport() {




        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().create(
            "/api/v1/org/privacy/oktaSupport/revoke",
            new DefaultVoidResource(getDataStore()),
            this,
            OrgOktaSupportSettingsObj.class,
            queryArgs,
            headers);

    }



}
