/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.resource.identity.provider;

import com.okta.commons.http.HttpHeaders;
import com.okta.commons.lang.Assert;
import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.sdk.impl.resource.AbstractInstanceResource;
import com.okta.sdk.impl.resource.DateProperty;
import com.okta.sdk.impl.resource.DefaultVoidResource;
import com.okta.sdk.impl.resource.EnumProperty;
import com.okta.sdk.impl.resource.MapProperty;
import com.okta.sdk.impl.resource.Property;
import com.okta.sdk.impl.resource.ResourceReference;
import com.okta.sdk.impl.resource.StringProperty;
import com.okta.sdk.resource.Resource;
import com.okta.sdk.resource.application.Csr;
import com.okta.sdk.resource.application.CsrList;
import com.okta.sdk.resource.application.CsrMetadata;
import com.okta.sdk.resource.application.JsonWebKey;
import com.okta.sdk.resource.application.JsonWebKeyList;
import com.okta.sdk.resource.identity.provider.IdentityProvider;
import com.okta.sdk.resource.identity.provider.IdentityProviderApplicationUser;
import com.okta.sdk.resource.identity.provider.IdentityProviderApplicationUserList;
import com.okta.sdk.resource.identity.provider.Protocol;
import com.okta.sdk.resource.identity.provider.SocialAuthTokenList;
import com.okta.sdk.resource.policy.IdentityProviderPolicy;
import com.okta.sdk.resource.policy.UserIdentityProviderLinkRequest;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultIdentityProvider
extends AbstractInstanceResource<IdentityProvider>
implements IdentityProvider {
    private static final MapProperty linksProperty = new MapProperty("_links");
    private static final DateProperty createdProperty = new DateProperty("created");
    private static final StringProperty idProperty = new StringProperty("id");
    private static final EnumProperty<IdentityProvider.IssuerModeEnum> issuerModeProperty = new EnumProperty<IdentityProvider.IssuerModeEnum>("issuerMode", IdentityProvider.IssuerModeEnum.class);
    private static final DateProperty lastUpdatedProperty = new DateProperty("lastUpdated");
    private static final StringProperty nameProperty = new StringProperty("name");
    private static final ResourceReference<IdentityProviderPolicy> policyProperty = new ResourceReference<IdentityProviderPolicy>("policy", IdentityProviderPolicy.class, false);
    private static final ResourceReference<Protocol> protocolProperty = new ResourceReference<Protocol>("protocol", Protocol.class, false);
    private static final EnumProperty<IdentityProvider.StatusEnum> statusProperty = new EnumProperty<IdentityProvider.StatusEnum>("status", IdentityProvider.StatusEnum.class);
    private static final EnumProperty<IdentityProvider.TypeEnum> typeProperty = new EnumProperty<IdentityProvider.TypeEnum>("type", IdentityProvider.TypeEnum.class);
    private static final Map<String, Property> PROPERTY_DESCRIPTORS = DefaultIdentityProvider.createPropertyDescriptorMap(linksProperty, createdProperty, idProperty, issuerModeProperty, lastUpdatedProperty, nameProperty, policyProperty, protocolProperty, statusProperty, typeProperty);

    public DefaultIdentityProvider(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultIdentityProvider(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    public Class<? extends Resource> getResourceClass() {
        return IdentityProvider.class;
    }

    public Map<String, Object> getLinks() {
        return this.getMap(linksProperty);
    }

    public Date getCreated() {
        return this.getDateProperty(createdProperty);
    }

    public String getId() {
        return this.getString(idProperty);
    }

    public IdentityProvider.IssuerModeEnum getIssuerMode() {
        return this.getEnumProperty(issuerModeProperty);
    }

    public IdentityProvider setIssuerMode(IdentityProvider.IssuerModeEnum issuerMode) {
        this.setProperty(issuerModeProperty, (Object)issuerMode);
        return this;
    }

    public Date getLastUpdated() {
        return this.getDateProperty(lastUpdatedProperty);
    }

    public String getName() {
        return this.getString(nameProperty);
    }

    public IdentityProvider setName(String name) {
        this.setProperty(nameProperty, (Object)name);
        return this;
    }

    public IdentityProviderPolicy getPolicy() {
        return this.getResourceProperty(policyProperty);
    }

    public IdentityProvider setPolicy(IdentityProviderPolicy policy) {
        this.setProperty(policyProperty, (Object)policy);
        return this;
    }

    public Protocol getProtocol() {
        return this.getResourceProperty(protocolProperty);
    }

    public IdentityProvider setProtocol(Protocol protocol) {
        this.setProperty(protocolProperty, (Object)protocol);
        return this;
    }

    public IdentityProvider.StatusEnum getStatus() {
        return this.getEnumProperty(statusProperty);
    }

    public IdentityProvider setStatus(IdentityProvider.StatusEnum status) {
        this.setProperty(statusProperty, (Object)status);
        return this;
    }

    public IdentityProvider.TypeEnum getType() {
        return this.getEnumProperty(typeProperty);
    }

    public IdentityProvider setType(IdentityProvider.TypeEnum type) {
        this.setProperty(typeProperty, (Object)type);
        return this;
    }

    public IdentityProviderApplicationUser getUser(String userId) {
        String idpId = this.getId();
        Assert.hasText((String)idpId, (String)"'idpId' is required and cannot be null or empty.");
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/idps/" + idpId + "/users/" + userId + "", IdentityProviderApplicationUser.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public Csr getSigningCsr(String csrId) {
        String idpId = this.getId();
        Assert.hasText((String)idpId, (String)"'idpId' is required and cannot be null or empty.");
        Assert.hasText((String)csrId, (String)"'csrId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/idps/" + idpId + "/credentials/csrs/" + csrId + "", Csr.class, queryArgs, (Map<String, List<String>>)headers);
    }

    @Override
    public void delete() {
        String idpId = this.getId();
        Assert.hasText((String)idpId, (String)"'idpId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/idps/" + idpId + "", this, queryArgs, (Map<String, List<String>>)headers);
    }

    public Csr generateCsr(CsrMetadata metadata) {
        String idpId = this.getId();
        Assert.notNull((Object)metadata, (String)"'metadata' is required and cannot be null.");
        Assert.hasText((String)idpId, (String)"'idpId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/idps/" + idpId + "/credentials/csrs", metadata, this, Csr.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
    }

    public IdentityProvider activate() {
        String idpId = this.getId();
        Assert.hasText((String)idpId, (String)"'idpId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/idps/" + idpId + "/lifecycle/activate", new DefaultVoidResource(this.getDataStore()), this, IdentityProvider.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public IdentityProviderApplicationUser linkUser(String userId, UserIdentityProviderLinkRequest userIdentityProviderLinkRequest) {
        String idpId = this.getId();
        Assert.notNull((Object)userIdentityProviderLinkRequest, (String)"'userIdentityProviderLinkRequest' is required and cannot be null.");
        Assert.hasText((String)idpId, (String)"'idpId' is required and cannot be null or empty.");
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/idps/" + idpId + "/users/" + userId + "", userIdentityProviderLinkRequest, this, IdentityProviderApplicationUser.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
    }

    public SocialAuthTokenList listSocialAuthTokens(String userId) {
        String idpId = this.getId();
        Assert.hasText((String)idpId, (String)"'idpId' is required and cannot be null or empty.");
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/idps/" + idpId + "/users/" + userId + "/credentials/tokens", SocialAuthTokenList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public JsonWebKeyList listSigningKeys() {
        String idpId = this.getId();
        Assert.hasText((String)idpId, (String)"'idpId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/idps/" + idpId + "/credentials/keys", JsonWebKeyList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void deleteSigningCsr(String csrId) {
        String idpId = this.getId();
        Assert.hasText((String)idpId, (String)"'idpId' is required and cannot be null or empty.");
        Assert.hasText((String)csrId, (String)"'csrId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/idps/" + idpId + "/credentials/csrs/" + csrId + "", queryArgs, (Map<String, List<String>>)headers);
    }

    public JsonWebKey getSigningKey(String keyId) {
        String idpId = this.getId();
        Assert.hasText((String)idpId, (String)"'idpId' is required and cannot be null or empty.");
        Assert.hasText((String)keyId, (String)"'keyId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/idps/" + idpId + "/credentials/keys/" + keyId + "", JsonWebKey.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public IdentityProvider update(IdentityProvider identityProvider) {
        String idpId = this.getId();
        Assert.notNull((Object)identityProvider, (String)"'identityProvider' is required and cannot be null.");
        Assert.hasText((String)idpId, (String)"'idpId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        String href = "/api/v1/idps/" + idpId + "";
        this.getDataStore().save(href, identityProvider, this, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return identityProvider;
    }

    public JsonWebKey generateSigningKey(Integer validityYears) {
        String idpId = this.getId();
        Assert.notNull((Object)validityYears, (String)"'validityYears' is required and cannot be null.");
        Assert.hasText((String)idpId, (String)"'idpId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (validityYears != null) {
            queryArgs.put("validityYears", validityYears);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/idps/" + idpId + "/credentials/keys/generate", new DefaultVoidResource(this.getDataStore()), this, JsonWebKey.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public IdentityProviderApplicationUserList listUsers() {
        String idpId = this.getId();
        Assert.hasText((String)idpId, (String)"'idpId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/idps/" + idpId + "/users", IdentityProviderApplicationUserList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void unlinkUser(String userId) {
        String idpId = this.getId();
        Assert.hasText((String)idpId, (String)"'idpId' is required and cannot be null or empty.");
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/idps/" + idpId + "/users/" + userId + "", queryArgs, (Map<String, List<String>>)headers);
    }

    public CsrList listSigningCsrs() {
        String idpId = this.getId();
        Assert.hasText((String)idpId, (String)"'idpId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/idps/" + idpId + "/credentials/csrs", CsrList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public IdentityProvider deactivate() {
        String idpId = this.getId();
        Assert.hasText((String)idpId, (String)"'idpId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/idps/" + idpId + "/lifecycle/deactivate", new DefaultVoidResource(this.getDataStore()), this, IdentityProvider.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public JsonWebKey cloneKey(String keyId, String targetIdpId) {
        String idpId = this.getId();
        Assert.notNull((Object)targetIdpId, (String)"'targetIdpId' is required and cannot be null.");
        Assert.hasText((String)idpId, (String)"'idpId' is required and cannot be null or empty.");
        Assert.hasText((String)keyId, (String)"'keyId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (targetIdpId != null) {
            queryArgs.put("targetIdpId", targetIdpId);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/idps/" + idpId + "/credentials/keys/" + keyId + "/clone", new DefaultVoidResource(this.getDataStore()), this, JsonWebKey.class, queryArgs, (Map<String, List<String>>)headers);
    }
}

