/*
 * Okta API
 * Allows customers to easily access the Okta API
 *
 * OpenAPI spec version: 2.7.2
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.okta.sdk.impl.resource.org;

import com.okta.sdk.resource.org.OrgContactUser;
import com.okta.sdk.resource.org.UserIdString;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


import com.okta.sdk.impl.resource.AbstractInstanceResource;
import com.okta.sdk.impl.resource.AbstractResource;
import com.okta.sdk.impl.resource.Property;
import com.okta.sdk.impl.resource.ResourceReference;
import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.commons.http.QueryString;
import com.okta.commons.http.HttpHeaders;

import com.okta.sdk.impl.resource.BooleanProperty;
import com.okta.sdk.impl.resource.IntegerProperty;
import com.okta.sdk.impl.resource.DoubleProperty;
import com.okta.sdk.impl.resource.StringProperty;
import com.okta.sdk.impl.resource.CharacterArrayProperty;
import com.okta.sdk.impl.resource.ListProperty;
import com.okta.sdk.impl.resource.EnumListProperty;
import com.okta.sdk.impl.resource.ResourceListProperty;
import com.okta.sdk.impl.resource.DateProperty;
import com.okta.sdk.impl.resource.EnumProperty;
import com.okta.sdk.impl.resource.MapProperty;
import com.okta.sdk.impl.resource.DefaultVoidResource;
import com.okta.sdk.resource.VoidResource;
import com.okta.sdk.resource.Resource;
import java.util.Map;
import java.util.HashMap;

import static com.okta.commons.lang.Assert.notNull;
import static com.okta.commons.lang.Assert.hasText;


/**
 * OrgContactUser
 */
@javax.annotation.Generated(
        value = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
        date  = "2021-10-11T13:51:56.108-05:00")
public class DefaultOrgContactUser extends AbstractInstanceResource<OrgContactUser> implements OrgContactUser {

    private final static MapProperty linksProperty = new MapProperty("_links");
    private final static StringProperty userIdProperty = new StringProperty("userId");

    private final static Map<String, Property> PROPERTY_DESCRIPTORS = createPropertyDescriptorMap(linksProperty, userIdProperty);

    public DefaultOrgContactUser(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultOrgContactUser(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    public Class<? extends Resource> getResourceClass() {
        return OrgContactUser.class;
    }

    public Map<String, Object> getLinks() {
        return  getMap(linksProperty);
    }

    public String getUserId() {
        return  getString(userIdProperty);
    }

    public OrgContactUser setUserId(String userId) {
        setProperty(userIdProperty, userId);
        return this;
    }


    /**
    * Update org contact user
    * Updates the User associated with the specified Contact Type.
    * @param contactType  (required)
    * @return OrgContactUser
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2021-10-11T13:51:56.108-05:00",
          comments = "PUT - /api/v1/org/contacts/{contactType}")
    public OrgContactUser updateContactUser(String contactType) {



        hasText(contactType, "'contactType' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();


        String href = "/api/v1/org/contacts/" + contactType + "";
        getDataStore().save(href, this, null, queryArgs, headers);
        return this;

    }



}
