/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.resource;

import com.okta.sdk.client.Client;
import com.okta.sdk.resource.policy.Policy;
import com.okta.sdk.resource.policy.PolicyRule;
import com.okta.sdk.resource.policy.rule.PolicyRuleBuilder;
import java.util.Objects;

public class DefaultPolicyRuleBuilder<T extends PolicyRuleBuilder>
implements PolicyRuleBuilder<T> {
    protected Integer priority;
    protected PolicyRule.TypeEnum type = PolicyRule.TypeEnum.SIGN_ON;
    protected PolicyRule.StatusEnum status;

    DefaultPolicyRuleBuilder() {
    }

    public T setPriority(Integer priority) {
        this.priority = priority;
        return this.self();
    }

    public T setStatus(PolicyRule.StatusEnum status) {
        this.status = status;
        return this.self();
    }

    public T setType(PolicyRule.TypeEnum type) {
        this.type = type;
        return this.self();
    }

    public PolicyRule buildAndCreate(Client client, Policy policy) {
        return policy.createRule(this.build(client));
    }

    protected T self() {
        return (T)this;
    }

    private PolicyRule build(Client client) {
        PolicyRule policyRule = (PolicyRule)client.instantiate(PolicyRule.class);
        if (Objects.nonNull(this.priority)) {
            policyRule.setPriority(this.priority);
        }
        if (Objects.nonNull(this.status)) {
            policyRule.setStatus(this.status);
        }
        if (Objects.nonNull(this.type)) {
            policyRule.setType(this.type);
        }
        return policyRule;
    }
}

