/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.ds;

import com.okta.commons.lang.Assert;
import com.okta.commons.lang.Collections;
import com.okta.commons.lang.Strings;
import com.okta.sdk.impl.http.QueryString;
import java.util.Map;

public class DefaultCacheKey {
    private final String url;

    public DefaultCacheKey(String href, QueryString queryString) {
        Assert.notNull((Object)href, (String)"href argument cannot be null.");
        String tmpUrl = href;
        QueryString qs = queryString;
        int questionMarkIndex = href.lastIndexOf(63);
        if (questionMarkIndex >= 0) {
            tmpUrl = href.substring(0, questionMarkIndex);
            String after = href.substring(questionMarkIndex + 1);
            if (Strings.hasLength((String)after)) {
                qs = new QueryString(queryString);
                QueryString queryStringFromHref = QueryString.create(after);
                qs.putAll(queryStringFromHref);
            }
        }
        if (!Collections.isEmpty((Map)qs)) {
            tmpUrl = tmpUrl + "?" + qs.toString();
        }
        this.url = tmpUrl;
    }

    public String toString() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof DefaultCacheKey) {
            DefaultCacheKey other = (DefaultCacheKey)o;
            return this.url.equals(other.url);
        }
        return false;
    }

    public int hashCode() {
        return this.url.hashCode();
    }
}

