/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.config;

import com.okta.sdk.cache.CacheConfigurationBuilder;
import com.okta.sdk.client.AuthenticationScheme;
import com.okta.sdk.client.Proxy;
import com.okta.sdk.impl.api.ClientCredentialsResolver;
import com.okta.sdk.impl.http.authc.RequestAuthenticatorFactory;
import com.okta.sdk.impl.util.BaseUrlResolver;
import java.util.LinkedHashMap;
import java.util.Map;

public class ClientConfiguration {
    private String apiToken;
    private ClientCredentialsResolver clientCredentialsResolver;
    private boolean cacheManagerEnabled;
    private long cacheManagerTtl;
    private long cacheManagerTti;
    private Map<String, CacheConfigurationBuilder> cacheManagerCaches = new LinkedHashMap<String, CacheConfigurationBuilder>();
    private String baseUrl;
    private int connectionTimeout;
    private AuthenticationScheme authenticationScheme;
    private RequestAuthenticatorFactory requestAuthenticatorFactory;
    private int proxyPort;
    private String proxyHost;
    private String proxyUsername;
    private String proxyPassword;
    private Proxy proxy;
    private BaseUrlResolver baseUrlResolver;
    private int retryMaxElapsed = 0;
    private int retryMaxAttempts = 0;

    public String getApiToken() {
        return this.apiToken;
    }

    public void setApiToken(String apiToken) {
        this.apiToken = apiToken;
    }

    public ClientCredentialsResolver getClientCredentialsResolver() {
        return this.clientCredentialsResolver;
    }

    public void setClientCredentialsResolver(ClientCredentialsResolver clientCredentialsResolver) {
        this.clientCredentialsResolver = clientCredentialsResolver;
    }

    public AuthenticationScheme getAuthenticationScheme() {
        return this.authenticationScheme;
    }

    public void setAuthenticationScheme(AuthenticationScheme authenticationScheme) {
        this.authenticationScheme = authenticationScheme;
    }

    public RequestAuthenticatorFactory getRequestAuthenticatorFactory() {
        return this.requestAuthenticatorFactory;
    }

    public void setRequestAuthenticatorFactory(RequestAuthenticatorFactory requestAuthenticatorFactory) {
        this.requestAuthenticatorFactory = requestAuthenticatorFactory;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public boolean isCacheManagerEnabled() {
        return this.cacheManagerEnabled;
    }

    public void setCacheManagerEnabled(boolean cacheManagerEnabled) {
        this.cacheManagerEnabled = cacheManagerEnabled;
    }

    public Map<String, CacheConfigurationBuilder> getCacheManagerCaches() {
        return this.cacheManagerCaches;
    }

    public void setCacheManagerCaches(Map<String, CacheConfigurationBuilder> cacheManagerCaches) {
        this.cacheManagerCaches = cacheManagerCaches;
    }

    public long getCacheManagerTti() {
        return this.cacheManagerTti;
    }

    public void setCacheManagerTti(long cacheManagerTti) {
        this.cacheManagerTti = cacheManagerTti;
    }

    public long getCacheManagerTtl() {
        return this.cacheManagerTtl;
    }

    public void setCacheManagerTtl(long cacheManagerTtl) {
        this.cacheManagerTtl = cacheManagerTtl;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    public BaseUrlResolver getBaseUrlResolver() {
        return this.baseUrlResolver;
    }

    public void setBaseUrlResolver(BaseUrlResolver baseUrlResolver) {
        this.baseUrlResolver = baseUrlResolver;
    }

    public Proxy getProxy() {
        if (this.proxy != null) {
            return this.proxy;
        }
        Proxy proxy = null;
        if (!(this.getProxyPort() <= 0 && this.getProxyHost() == null || this.getProxyUsername() != null && this.getProxyPassword() != null)) {
            proxy = new Proxy(this.getProxyHost(), this.getProxyPort());
        } else if (this.getProxyUsername() != null && this.getProxyPassword() != null) {
            proxy = new Proxy(this.getProxyHost(), this.getProxyPort(), this.getProxyUsername(), this.getProxyPassword());
        }
        this.proxy = proxy;
        return this.proxy;
    }

    public ClientConfiguration setProxy(Proxy proxy) {
        this.proxy = proxy;
        return this;
    }

    public int getRetryMaxElapsed() {
        return this.retryMaxElapsed;
    }

    public ClientConfiguration setRetryMaxElapsed(int retryMaxElapsed) {
        this.retryMaxElapsed = retryMaxElapsed;
        return this;
    }

    public int getRetryMaxAttempts() {
        return this.retryMaxAttempts;
    }

    public ClientConfiguration setRetryMaxAttempts(int retryMaxAttempts) {
        this.retryMaxAttempts = retryMaxAttempts;
        return this;
    }

    public String toString() {
        return "ClientConfiguration{, cacheManagerTtl=" + this.cacheManagerTtl + ", cacheManagerTti=" + this.cacheManagerTti + ", cacheManagerCaches=" + this.cacheManagerCaches + ", baseUrl='" + this.baseUrl + '\'' + ", connectionTimeout=" + this.connectionTimeout + ", authenticationScheme=" + this.authenticationScheme + ", retryMaxElapsed=" + this.retryMaxElapsed + ", retryMaxAttempts=" + this.retryMaxAttempts + ", proxy=" + this.proxy + '}';
    }
}

