/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openapitools.client.model.IamRoleLinks;
import org.openapitools.client.model.RolePermissionType;

@JsonPropertyOrder(value={"created", "description", "id", "label", "lastUpdated", "permissions", "_links"})
public class IamRole {
    public static final String JSON_PROPERTY_CREATED = "created";
    private OffsetDateTime created;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_LABEL = "label";
    private String label;
    public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
    private OffsetDateTime lastUpdated;
    public static final String JSON_PROPERTY_PERMISSIONS = "permissions";
    private List<RolePermissionType> permissions = new ArrayList<RolePermissionType>();
    public static final String JSON_PROPERTY_LINKS = "_links";
    private IamRoleLinks links;

    @Nullable
    @ApiModelProperty(value="Timestamp when the role was created")
    @JsonProperty(value="created")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreated() {
        return this.created;
    }

    public IamRole description(String description) {
        this.description = description;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Description of the role")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDescription(String description) {
        this.description = description;
    }

    @Nullable
    @ApiModelProperty(value="Unique key for the role")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    public IamRole label(String label) {
        this.label = label;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Unique label for the role")
    @JsonProperty(value="label")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getLabel() {
        return this.label;
    }

    @JsonProperty(value="label")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLabel(String label) {
        this.label = label;
    }

    @Nullable
    @ApiModelProperty(value="Timestamp when the role was last updated")
    @JsonProperty(value="lastUpdated")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getLastUpdated() {
        return this.lastUpdated;
    }

    public IamRole permissions(List<RolePermissionType> permissions) {
        this.permissions = permissions;
        return this;
    }

    public IamRole addPermissionsItem(RolePermissionType permissionsItem) {
        this.permissions.add(permissionsItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Array of permissions that the role will grant. See [Permission Types](https://developer.okta.com/docs/concepts/role-assignment/#permission-types).")
    @JsonProperty(value="permissions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<RolePermissionType> getPermissions() {
        return this.permissions;
    }

    @JsonProperty(value="permissions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPermissions(List<RolePermissionType> permissions) {
        this.permissions = permissions;
    }

    public IamRole links(IamRoleLinks links) {
        this.links = links;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IamRoleLinks getLinks() {
        return this.links;
    }

    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(IamRoleLinks links) {
        this.links = links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IamRole iamRole = (IamRole)o;
        return Objects.equals(this.created, iamRole.created) && Objects.equals(this.description, iamRole.description) && Objects.equals(this.id, iamRole.id) && Objects.equals(this.label, iamRole.label) && Objects.equals(this.lastUpdated, iamRole.lastUpdated) && Objects.equals(this.permissions, iamRole.permissions) && Objects.equals(this.links, iamRole.links);
    }

    public int hashCode() {
        return Objects.hash(this.created, this.description, this.id, this.label, this.lastUpdated, this.permissions, this.links);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IamRole {\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    label: ").append(this.toIndentedString(this.label)).append("\n");
        sb.append("    lastUpdated: ").append(this.toIndentedString(this.lastUpdated)).append("\n");
        sb.append("    permissions: ").append(this.toIndentedString(this.permissions)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

