/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.client;

public class Proxy {
    private final String host;
    private final int port;
    private final String username;
    private final String password;
    private final boolean authenticationRequired;

    public Proxy(String host, int port) {
        this(host, port, null, null, false);
    }

    public Proxy(String host, int port, String username, String password) {
        this(host, port, username, password, true);
    }

    private Proxy(String host, int port, String username, String password, boolean authenticationRequired) {
        if (host == null) {
            throw new IllegalArgumentException("host argument cannot be null");
        }
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("port must be be between 0 and 65535");
        }
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
        this.authenticationRequired = authenticationRequired;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isAuthenticationRequired() {
        return this.authenticationRequired;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("host=").append(this.host).append(", port=").append(this.port);
        if (this.username != null) {
            sb.append(", username=").append(this.username);
        }
        if (this.password != null) {
            sb.append(", password=<hidden>");
        }
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.host != null ? this.host.hashCode() : 0);
        result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
        result = 31 * result + this.port;
        result = 31 * result + (this.username != null ? this.username.hashCode() : 0);
        result = 31 * result + (this.authenticationRequired ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Proxy) {
            Proxy p = (Proxy)obj;
            return (this.host != null ? this.host.equals(p.getHost()) : p.getHost() == null) && this.port == p.getPort() && (this.username != null ? this.username.equals(p.getUsername()) : p.getUsername() == null) && (this.password != null ? this.password.equals(p.getPassword()) : p.getPassword() == null) && this.authenticationRequired == p.authenticationRequired;
        }
        return false;
    }
}

