/*
 * Decompiled with CFR 0.152.
 */
package com.okta.jwt.impl.jjwt;

import com.okta.jwt.IdTokenVerifier;
import com.okta.jwt.Jwt;
import com.okta.jwt.JwtVerificationException;
import com.okta.jwt.impl.jjwt.ClaimsValidator;
import com.okta.jwt.impl.jjwt.TokenVerifierSupport;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.IncorrectClaimException;
import io.jsonwebtoken.SigningKeyResolver;
import io.jsonwebtoken.lang.Objects;
import java.time.Duration;

public class JjwtIdTokenVerifier
extends TokenVerifierSupport
implements IdTokenVerifier {
    private final String clientId;

    public JjwtIdTokenVerifier(String issuer, String clientId, Duration leeway, SigningKeyResolver signingKeyResolver) {
        super(issuer, leeway, signingKeyResolver);
        this.clientId = clientId;
    }

    public Jwt decode(String idToken, String nonce) throws JwtVerificationException {
        return this.decode(idToken, this.parser(), ClaimsValidator.compositeClaimsValidator(new ClaimsValidator.ContainsAudienceClaimsValidator(this.clientId), jws -> {
            String actualNonce = (String)((Claims)jws.getBody()).get("nonce", String.class);
            if (!Objects.nullSafeEquals((Object)actualNonce, (Object)nonce)) {
                throw new IncorrectClaimException(jws.getHeader(), (Claims)jws.getBody(), "nonce", (Object)actualNonce, "Claim `nonce` does not match expected value. Note: a `null` nonce is only valid when both the expected and actual values are `null`.");
            }
        }));
    }
}

