/*
 * Decompiled with CFR 0.152.
 */
package com.okta.commons.http.config;

import com.okta.commons.http.authc.RequestAuthenticator;
import com.okta.commons.http.config.Proxy;
import java.util.HashMap;
import java.util.Map;
import nl.altindag.ssl.SSLFactory;

public class HttpClientConfiguration {
    private String baseUrl;
    private int connectionTimeout;
    private RequestAuthenticator requestAuthenticator;
    private int proxyPort;
    private String proxyHost;
    private String proxyUsername;
    private String proxyPassword;
    private Proxy proxy;
    private int retryMaxElapsed = 0;
    private int retryMaxAttempts = 0;
    private SSLFactory sslFactory;
    private final Map<String, String> requestExecutorParams = new HashMap<String, String>();

    public RequestAuthenticator getRequestAuthenticator() {
        return this.requestAuthenticator;
    }

    public void setRequestAuthenticator(RequestAuthenticator requestAuthenticator) {
        this.requestAuthenticator = requestAuthenticator;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    public Proxy getProxy() {
        if (this.proxy != null) {
            return this.proxy;
        }
        Proxy proxy = null;
        if (!(this.getProxyPort() <= 0 && this.getProxyHost() == null || this.getProxyUsername() != null && this.getProxyPassword() != null)) {
            proxy = new Proxy(this.getProxyHost(), this.getProxyPort());
        } else if (this.getProxyUsername() != null && this.getProxyPassword() != null) {
            proxy = new Proxy(this.getProxyHost(), this.getProxyPort(), this.getProxyUsername(), this.getProxyPassword());
        }
        this.proxy = proxy;
        return this.proxy;
    }

    public HttpClientConfiguration setProxy(Proxy proxy) {
        this.proxy = proxy;
        return this;
    }

    public int getRetryMaxElapsed() {
        return this.retryMaxElapsed;
    }

    public HttpClientConfiguration setRetryMaxElapsed(int retryMaxElapsed) {
        this.retryMaxElapsed = retryMaxElapsed;
        return this;
    }

    public int getRetryMaxAttempts() {
        return this.retryMaxAttempts;
    }

    public HttpClientConfiguration setRetryMaxAttempts(int retryMaxAttempts) {
        this.retryMaxAttempts = retryMaxAttempts;
        return this;
    }

    public SSLFactory getSslFactory() {
        return this.sslFactory;
    }

    public void setSslFactory(SSLFactory sslFactory) {
        this.sslFactory = sslFactory;
    }

    public void setRequestExecutorParams(Map<String, String> map) {
        this.requestExecutorParams.putAll(map);
    }

    public Map<String, String> getRequestExecutorParams() {
        return this.requestExecutorParams;
    }

    public String toString() {
        return "ClientConfiguration{, baseUrl='" + this.baseUrl + '\'' + ", connectionTimeout=" + this.connectionTimeout + ", requestAuthenticator=" + this.requestAuthenticator + ", retryMaxElapsed=" + this.retryMaxElapsed + ", retryMaxAttempts=" + this.retryMaxAttempts + ", proxy=" + this.proxy + '}';
    }
}

