/*
 * Decompiled with CFR 0.152.
 */
package com.ogaclejapan.smarttablayout.utils.v4;

import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentStatePagerAdapter;
import android.support.v4.util.SparseArrayCompat;
import android.view.ViewGroup;
import com.ogaclejapan.smarttablayout.utils.v4.FragmentPagerItem;
import com.ogaclejapan.smarttablayout.utils.v4.FragmentPagerItems;
import java.lang.ref.WeakReference;

public class FragmentStatePagerItemAdapter
extends FragmentStatePagerAdapter {
    private final FragmentPagerItems pages;
    private final SparseArrayCompat<WeakReference<Fragment>> holder;

    public FragmentStatePagerItemAdapter(FragmentManager fm, FragmentPagerItems pages) {
        super(fm);
        this.pages = pages;
        this.holder = new SparseArrayCompat(pages.size());
    }

    public int getCount() {
        return this.pages.size();
    }

    public Fragment getItem(int position) {
        return this.getPagerItem(position).instantiate(this.pages.getContext(), position);
    }

    public Object instantiateItem(ViewGroup container, int position) {
        Object item = super.instantiateItem(container, position);
        if (item instanceof Fragment) {
            this.holder.put(position, new WeakReference<Fragment>((Fragment)item));
        }
        return item;
    }

    public void destroyItem(ViewGroup container, int position, Object object) {
        this.holder.remove(position);
        super.destroyItem(container, position, object);
    }

    public CharSequence getPageTitle(int position) {
        return this.getPagerItem(position).getTitle();
    }

    public float getPageWidth(int position) {
        return this.getPagerItem(position).getWidth();
    }

    public Fragment getPage(int position) {
        WeakReference weakRefItem = (WeakReference)this.holder.get(position);
        return weakRefItem != null ? (Fragment)weakRefItem.get() : null;
    }

    protected FragmentPagerItem getPagerItem(int position) {
        return (FragmentPagerItem)this.pages.get(position);
    }
}

