/*
 * Decompiled with CFR 0.152.
 */
package com.ogaclejapan.smarttablayout.utils.v4;

import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentStatePagerAdapter;
import android.support.v4.util.SparseArrayCompat;
import android.view.ViewGroup;
import com.ogaclejapan.smarttablayout.utils.v4.FragmentPagerItem;
import com.ogaclejapan.smarttablayout.utils.v4.FragmentPagerItems;
import java.lang.ref.WeakReference;

public class FragmentStatePagerItemAdapter
extends FragmentStatePagerAdapter {
    private final FragmentPagerItems mPages;
    private final SparseArrayCompat<WeakReference<Fragment>> mHolder;

    public FragmentStatePagerItemAdapter(FragmentManager fm, FragmentPagerItems pages) {
        super(fm);
        this.mPages = pages;
        this.mHolder = new SparseArrayCompat(pages.size());
    }

    public int getCount() {
        return this.mPages.size();
    }

    public Fragment getItem(int position) {
        return this.getPagerItem(position).instantiate(this.mPages.getContext(), position);
    }

    public Object instantiateItem(ViewGroup container, int position) {
        Object item = super.instantiateItem(container, position);
        if (item instanceof Fragment) {
            this.mHolder.put(position, new WeakReference<Fragment>((Fragment)item));
        }
        return item;
    }

    public void destroyItem(ViewGroup container, int position, Object object) {
        this.mHolder.remove(position);
        super.destroyItem(container, position, object);
    }

    public CharSequence getPageTitle(int position) {
        return this.getPagerItem(position).getTitle();
    }

    public float getPageWidth(int position) {
        return this.getPagerItem(position).getWidth();
    }

    public Fragment getPage(int position) {
        WeakReference weakRefItem = (WeakReference)this.mHolder.get(position);
        return weakRefItem != null ? (Fragment)weakRefItem.get() : null;
    }

    protected FragmentPagerItem getPagerItem(int position) {
        return (FragmentPagerItem)this.mPages.get(position);
    }
}

