/*
 * Decompiled with CFR 0.152.
 */
package com.ogaclejapan.smarttablayout;

import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;

public abstract class SmartTabIndicationInterpolator {
    public static final SmartTabIndicationInterpolator SMART = new SmartIndicationInterpolator();
    public static final SmartTabIndicationInterpolator LINEAR = new LinearIndicationInterpolator();
    static final int ID_SMART = 0;
    static final int ID_LINEAR = 1;

    public static SmartTabIndicationInterpolator of(int id) {
        switch (id) {
            case 0: {
                return SMART;
            }
            case 1: {
                return LINEAR;
            }
        }
        throw new IllegalArgumentException("Unknown id: " + id);
    }

    public abstract float getLeftEdge(float var1);

    public abstract float getRightEdge(float var1);

    public float getThickness(float offset) {
        return 1.0f;
    }

    public static class LinearIndicationInterpolator
    extends SmartTabIndicationInterpolator {
        @Override
        public float getLeftEdge(float offset) {
            return offset;
        }

        @Override
        public float getRightEdge(float offset) {
            return offset;
        }
    }

    public static class SmartIndicationInterpolator
    extends SmartTabIndicationInterpolator {
        private static final float DEFAULT_INDICATOR_INTERPOLATION_FACTOR = 3.0f;
        private final Interpolator leftEdgeInterpolator;
        private final Interpolator rightEdgeInterpolator;

        public SmartIndicationInterpolator() {
            this(3.0f);
        }

        public SmartIndicationInterpolator(float factor) {
            this.leftEdgeInterpolator = new AccelerateInterpolator(factor);
            this.rightEdgeInterpolator = new DecelerateInterpolator(factor);
        }

        @Override
        public float getLeftEdge(float offset) {
            return this.leftEdgeInterpolator.getInterpolation(offset);
        }

        @Override
        public float getRightEdge(float offset) {
            return this.rightEdgeInterpolator.getInterpolation(offset);
        }

        @Override
        public float getThickness(float offset) {
            return 1.0f / (1.0f - this.getLeftEdge(offset) + this.getRightEdge(offset));
        }
    }
}

