/*
 * Decompiled with CFR 0.152.
 */
package com.ogaclejapan.smarttablayout;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.os.Build;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.HorizontalScrollView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.ogaclejapan.smarttablayout.R;
import com.ogaclejapan.smarttablayout.SmartTabIndicationInterpolator;
import com.ogaclejapan.smarttablayout.SmartTabStrip;
import com.ogaclejapan.smarttablayout.Utils;

public class SmartTabLayout
extends HorizontalScrollView {
    private static final boolean DEFAULT_DISTRIBUTE_EVENLY = false;
    private static final int TITLE_OFFSET_DIPS = 24;
    private static final int TITLE_OFFSET_AUTO_CENTER = -1;
    private static final int TAB_VIEW_PADDING_DIPS = 16;
    private static final boolean TAB_VIEW_TEXT_ALL_CAPS = true;
    private static final int TAB_VIEW_TEXT_SIZE_SP = 12;
    private static final int TAB_VIEW_TEXT_COLOR = -67108864;
    private static final int TAB_VIEW_TEXT_MIN_WIDTH = 0;
    private static final boolean TAB_CLICKABLE = true;
    protected final SmartTabStrip tabStrip;
    private int titleOffset;
    private int tabViewBackgroundResId;
    private boolean tabViewTextAllCaps;
    private ColorStateList tabViewTextColors;
    private float tabViewTextSize;
    private int tabViewTextHorizontalPadding;
    private int tabViewTextMinWidth;
    private ViewPager viewPager;
    private ViewPager.OnPageChangeListener viewPagerPageChangeListener;
    private OnScrollChangeListener onScrollChangeListener;
    private TabProvider tabProvider;
    private InternalTabClickListener internalTabClickListener;
    private OnTabClickListener onTabClickListener;
    private boolean distributeEvenly;

    public SmartTabLayout(Context context) {
        this(context, null);
    }

    public SmartTabLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SmartTabLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setHorizontalScrollBarEnabled(false);
        DisplayMetrics dm = this.getResources().getDisplayMetrics();
        float density = dm.density;
        int tabBackgroundResId = -1;
        boolean textAllCaps = true;
        float textSize = TypedValue.applyDimension((int)2, (float)12.0f, (DisplayMetrics)dm);
        int textHorizontalPadding = (int)(16.0f * density);
        int textMinWidth = (int)(0.0f * density);
        boolean distributeEvenly = false;
        int customTabLayoutId = -1;
        int customTabTextViewId = -1;
        boolean clickable = true;
        int titleOffset = (int)(24.0f * density);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.stl_SmartTabLayout, defStyle, 0);
        tabBackgroundResId = a.getResourceId(R.styleable.stl_SmartTabLayout_stl_defaultTabBackground, tabBackgroundResId);
        textAllCaps = a.getBoolean(R.styleable.stl_SmartTabLayout_stl_defaultTabTextAllCaps, textAllCaps);
        ColorStateList textColors = a.getColorStateList(R.styleable.stl_SmartTabLayout_stl_defaultTabTextColor);
        textSize = a.getDimension(R.styleable.stl_SmartTabLayout_stl_defaultTabTextSize, textSize);
        textHorizontalPadding = a.getDimensionPixelSize(R.styleable.stl_SmartTabLayout_stl_defaultTabTextHorizontalPadding, textHorizontalPadding);
        textMinWidth = a.getDimensionPixelSize(R.styleable.stl_SmartTabLayout_stl_defaultTabTextMinWidth, textMinWidth);
        customTabLayoutId = a.getResourceId(R.styleable.stl_SmartTabLayout_stl_customTabTextLayoutId, customTabLayoutId);
        customTabTextViewId = a.getResourceId(R.styleable.stl_SmartTabLayout_stl_customTabTextViewId, customTabTextViewId);
        distributeEvenly = a.getBoolean(R.styleable.stl_SmartTabLayout_stl_distributeEvenly, distributeEvenly);
        clickable = a.getBoolean(R.styleable.stl_SmartTabLayout_stl_clickable, clickable);
        titleOffset = a.getLayoutDimension(R.styleable.stl_SmartTabLayout_stl_titleOffset, titleOffset);
        a.recycle();
        this.titleOffset = titleOffset;
        this.tabViewBackgroundResId = tabBackgroundResId;
        this.tabViewTextAllCaps = textAllCaps;
        this.tabViewTextColors = textColors != null ? textColors : ColorStateList.valueOf((int)-67108864);
        this.tabViewTextSize = textSize;
        this.tabViewTextHorizontalPadding = textHorizontalPadding;
        this.tabViewTextMinWidth = textMinWidth;
        this.internalTabClickListener = clickable ? new InternalTabClickListener() : null;
        this.distributeEvenly = distributeEvenly;
        if (customTabLayoutId != -1) {
            this.setCustomTabView(customTabLayoutId, customTabTextViewId);
        }
        this.tabStrip = new SmartTabStrip(context, attrs);
        if (distributeEvenly && this.tabStrip.isIndicatorAlwaysInCenter()) {
            throw new UnsupportedOperationException("'distributeEvenly' and 'indicatorAlwaysInCenter' both use does not support");
        }
        this.setFillViewport(!this.tabStrip.isIndicatorAlwaysInCenter());
        this.addView((View)this.tabStrip, -1, -1);
    }

    protected void onScrollChanged(int l, int t, int oldl, int oldt) {
        super.onScrollChanged(l, t, oldl, oldt);
        if (this.onScrollChangeListener != null) {
            this.onScrollChangeListener.onScrollChanged(l, oldl);
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (this.tabStrip.isIndicatorAlwaysInCenter() && this.tabStrip.getChildCount() > 0) {
            View firstTab = this.tabStrip.getChildAt(0);
            View lastTab = this.tabStrip.getChildAt(this.getChildCount() - 1);
            int start = (w - Utils.getMeasuredWidth(firstTab)) / 2 - Utils.getMarginStart(firstTab);
            int end = (w - Utils.getMeasuredWidth(lastTab)) / 2 - Utils.getMarginEnd(lastTab);
            this.tabStrip.setMinimumWidth(this.tabStrip.getMeasuredWidth());
            ViewCompat.setPaddingRelative((View)this, (int)start, (int)this.getPaddingTop(), (int)end, (int)this.getPaddingBottom());
            this.setClipToPadding(false);
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        if (changed && this.viewPager != null) {
            this.scrollToTab(this.viewPager.getCurrentItem(), 0.0f);
        }
    }

    public void setIndicationInterpolator(SmartTabIndicationInterpolator interpolator) {
        this.tabStrip.setIndicationInterpolator(interpolator);
    }

    public void setCustomTabColorizer(TabColorizer tabColorizer) {
        this.tabStrip.setCustomTabColorizer(tabColorizer);
    }

    public void setDefaultTabTextColor(int color) {
        this.tabViewTextColors = ColorStateList.valueOf((int)color);
    }

    public void setDefaultTabTextColor(ColorStateList colors) {
        this.tabViewTextColors = colors;
    }

    public void setDistributeEvenly(boolean distributeEvenly) {
        this.distributeEvenly = distributeEvenly;
    }

    public void setSelectedIndicatorColors(int ... colors) {
        this.tabStrip.setSelectedIndicatorColors(colors);
    }

    public void setDividerColors(int ... colors) {
        this.tabStrip.setDividerColors(colors);
    }

    public void setOnPageChangeListener(ViewPager.OnPageChangeListener listener) {
        this.viewPagerPageChangeListener = listener;
    }

    public void setOnScrollChangeListener(OnScrollChangeListener listener) {
        this.onScrollChangeListener = listener;
    }

    public void setOnTabClickListener(OnTabClickListener listener) {
        this.onTabClickListener = listener;
    }

    public void setCustomTabView(int layoutResId, int textViewId) {
        this.tabProvider = new SimpleTabProvider(this.getContext(), layoutResId, textViewId);
    }

    public void setCustomTabView(TabProvider provider) {
        this.tabProvider = provider;
    }

    public void setViewPager(ViewPager viewPager) {
        this.tabStrip.removeAllViews();
        this.viewPager = viewPager;
        if (viewPager != null && viewPager.getAdapter() != null) {
            viewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)new InternalViewPagerListener());
            this.populateTabStrip();
        }
    }

    public View getTabAt(int position) {
        return this.tabStrip.getChildAt(position);
    }

    protected TextView createDefaultTabView(CharSequence title) {
        TextView textView = new TextView(this.getContext());
        textView.setGravity(17);
        textView.setText(title);
        textView.setTextColor(this.tabViewTextColors);
        textView.setTextSize(0, this.tabViewTextSize);
        textView.setTypeface(Typeface.DEFAULT_BOLD);
        textView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -1));
        if (this.tabViewBackgroundResId != -1) {
            textView.setBackgroundResource(this.tabViewBackgroundResId);
        } else if (Build.VERSION.SDK_INT >= 11) {
            TypedValue outValue = new TypedValue();
            this.getContext().getTheme().resolveAttribute(16843534, outValue, true);
            textView.setBackgroundResource(outValue.resourceId);
        }
        if (Build.VERSION.SDK_INT >= 14) {
            textView.setAllCaps(this.tabViewTextAllCaps);
        }
        textView.setPadding(this.tabViewTextHorizontalPadding, 0, this.tabViewTextHorizontalPadding, 0);
        if (this.tabViewTextMinWidth > 0) {
            textView.setMinWidth(this.tabViewTextMinWidth);
        }
        return textView;
    }

    private void populateTabStrip() {
        PagerAdapter adapter = this.viewPager.getAdapter();
        for (int i = 0; i < adapter.getCount(); ++i) {
            TextView tabView;
            Object object = tabView = this.tabProvider == null ? this.createDefaultTabView(adapter.getPageTitle(i)) : this.tabProvider.createTabView((ViewGroup)this.tabStrip, i, adapter);
            if (tabView == null) {
                throw new IllegalStateException("tabView is null.");
            }
            if (this.distributeEvenly) {
                LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)tabView.getLayoutParams();
                lp.width = 0;
                lp.weight = 1.0f;
            }
            if (this.internalTabClickListener != null) {
                tabView.setOnClickListener((View.OnClickListener)this.internalTabClickListener);
            }
            this.tabStrip.addView((View)tabView);
            if (i != this.viewPager.getCurrentItem()) continue;
            tabView.setSelected(true);
        }
    }

    private void scrollToTab(int tabIndex, float positionOffset) {
        int x;
        int tabStripChildCount = this.tabStrip.getChildCount();
        if (tabStripChildCount == 0 || tabIndex < 0 || tabIndex >= tabStripChildCount) {
            return;
        }
        boolean isLayoutRtl = Utils.isLayoutRtl((View)this);
        View selectedTab = this.tabStrip.getChildAt(tabIndex);
        int widthPlusMargin = Utils.getWidth(selectedTab) + Utils.getMarginHorizontally(selectedTab);
        int extraOffset = (int)(positionOffset * (float)widthPlusMargin);
        if (this.tabStrip.isIndicatorAlwaysInCenter()) {
            int x2;
            int first;
            if (0.0f < positionOffset && positionOffset < 1.0f) {
                View nextTab = this.tabStrip.getChildAt(tabIndex + 1);
                int selectHalfWidth = Utils.getWidth(selectedTab) / 2 + Utils.getMarginEnd(selectedTab);
                int nextHalfWidth = Utils.getWidth(nextTab) / 2 + Utils.getMarginStart(nextTab);
                extraOffset = Math.round(positionOffset * (float)(selectHalfWidth + nextHalfWidth));
            }
            View firstTab = this.tabStrip.getChildAt(0);
            if (isLayoutRtl) {
                first = Utils.getWidth(firstTab) + Utils.getMarginEnd(firstTab);
                int selected = Utils.getWidth(selectedTab) + Utils.getMarginEnd(selectedTab);
                x2 = Utils.getEnd(selectedTab) - Utils.getMarginEnd(selectedTab) - extraOffset;
                x2 -= (first - selected) / 2;
            } else {
                first = Utils.getWidth(firstTab) + Utils.getMarginStart(firstTab);
                int selected = Utils.getWidth(selectedTab) + Utils.getMarginStart(selectedTab);
                x2 = Utils.getStart(selectedTab) - Utils.getMarginStart(selectedTab) + extraOffset;
                x2 -= (first - selected) / 2;
            }
            this.scrollTo(x2, 0);
            return;
        }
        if (this.titleOffset == -1) {
            if (0.0f < positionOffset && positionOffset < 1.0f) {
                View nextTab = this.tabStrip.getChildAt(tabIndex + 1);
                int selectHalfWidth = Utils.getWidth(selectedTab) / 2 + Utils.getMarginEnd(selectedTab);
                int nextHalfWidth = Utils.getWidth(nextTab) / 2 + Utils.getMarginStart(nextTab);
                extraOffset = Math.round(positionOffset * (float)(selectHalfWidth + nextHalfWidth));
            }
            if (isLayoutRtl) {
                x = -Utils.getWidthWithMargin(selectedTab) / 2 + this.getWidth() / 2;
                x -= Utils.getPaddingStart((View)this);
            } else {
                x = Utils.getWidthWithMargin(selectedTab) / 2 - this.getWidth() / 2;
                x += Utils.getPaddingStart((View)this);
            }
        } else {
            x = isLayoutRtl ? (tabIndex > 0 || positionOffset > 0.0f ? this.titleOffset : 0) : (tabIndex > 0 || positionOffset > 0.0f ? -this.titleOffset : 0);
        }
        int start = Utils.getStart(selectedTab);
        int startMargin = Utils.getMarginStart(selectedTab);
        x = isLayoutRtl ? (x += start + startMargin - extraOffset - this.getWidth() + Utils.getPaddingHorizontally((View)this)) : (x += start - startMargin + extraOffset);
        this.scrollTo(x, 0);
    }

    private class InternalTabClickListener
    implements View.OnClickListener {
        private InternalTabClickListener() {
        }

        public void onClick(View v) {
            for (int i = 0; i < SmartTabLayout.this.tabStrip.getChildCount(); ++i) {
                if (v != SmartTabLayout.this.tabStrip.getChildAt(i)) continue;
                if (SmartTabLayout.this.onTabClickListener != null) {
                    SmartTabLayout.this.onTabClickListener.onTabClicked(i);
                }
                SmartTabLayout.this.viewPager.setCurrentItem(i);
                return;
            }
        }
    }

    private class InternalViewPagerListener
    implements ViewPager.OnPageChangeListener {
        private int scrollState;

        private InternalViewPagerListener() {
        }

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            int tabStripChildCount = SmartTabLayout.this.tabStrip.getChildCount();
            if (tabStripChildCount == 0 || position < 0 || position >= tabStripChildCount) {
                return;
            }
            SmartTabLayout.this.tabStrip.onViewPagerPageChanged(position, positionOffset);
            SmartTabLayout.this.scrollToTab(position, positionOffset);
            if (SmartTabLayout.this.viewPagerPageChangeListener != null) {
                SmartTabLayout.this.viewPagerPageChangeListener.onPageScrolled(position, positionOffset, positionOffsetPixels);
            }
        }

        public void onPageScrollStateChanged(int state) {
            this.scrollState = state;
            if (SmartTabLayout.this.viewPagerPageChangeListener != null) {
                SmartTabLayout.this.viewPagerPageChangeListener.onPageScrollStateChanged(state);
            }
        }

        public void onPageSelected(int position) {
            if (this.scrollState == 0) {
                SmartTabLayout.this.tabStrip.onViewPagerPageChanged(position, 0.0f);
                SmartTabLayout.this.scrollToTab(position, 0.0f);
            }
            int size = SmartTabLayout.this.tabStrip.getChildCount();
            for (int i = 0; i < size; ++i) {
                SmartTabLayout.this.tabStrip.getChildAt(i).setSelected(position == i);
            }
            if (SmartTabLayout.this.viewPagerPageChangeListener != null) {
                SmartTabLayout.this.viewPagerPageChangeListener.onPageSelected(position);
            }
        }
    }

    private static class SimpleTabProvider
    implements TabProvider {
        private final LayoutInflater inflater;
        private final int tabViewLayoutId;
        private final int tabViewTextViewId;

        private SimpleTabProvider(Context context, int layoutResId, int textViewId) {
            this.inflater = LayoutInflater.from((Context)context);
            this.tabViewLayoutId = layoutResId;
            this.tabViewTextViewId = textViewId;
        }

        @Override
        public View createTabView(ViewGroup container, int position, PagerAdapter adapter) {
            View tabView = null;
            TextView tabTitleView = null;
            if (this.tabViewLayoutId != -1) {
                tabView = this.inflater.inflate(this.tabViewLayoutId, container, false);
            }
            if (this.tabViewTextViewId != -1 && tabView != null) {
                tabTitleView = (TextView)tabView.findViewById(this.tabViewTextViewId);
            }
            if (tabTitleView == null && TextView.class.isInstance(tabView)) {
                tabTitleView = (TextView)tabView;
            }
            if (tabTitleView != null) {
                tabTitleView.setText(adapter.getPageTitle(position));
            }
            return tabView;
        }
    }

    public static interface TabProvider {
        public View createTabView(ViewGroup var1, int var2, PagerAdapter var3);
    }

    public static interface OnTabClickListener {
        public void onTabClicked(int var1);
    }

    public static interface OnScrollChangeListener {
        public void onScrollChanged(int var1, int var2);
    }

    public static interface TabColorizer {
        public int getIndicatorColor(int var1);

        public int getDividerColor(int var1);
    }
}

