/*
 * Decompiled with CFR 0.152.
 */
package com.ogaclejapan.smarttablayout;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.View;
import android.widget.LinearLayout;
import com.ogaclejapan.smarttablayout.R;
import com.ogaclejapan.smarttablayout.SmartTabIndicationInterpolator;
import com.ogaclejapan.smarttablayout.SmartTabLayout;
import com.ogaclejapan.smarttablayout.Utils;

class SmartTabStrip
extends LinearLayout {
    private static final int GRAVITY_BOTTOM = 0;
    private static final int GRAVITY_TOP = 1;
    private static final int GRAVITY_CENTER = 2;
    private static final int DEFAULT_TOP_BORDER_THICKNESS_DIPS = 0;
    private static final byte DEFAULT_TOP_BORDER_COLOR_ALPHA = 38;
    private static final int DEFAULT_BOTTOM_BORDER_THICKNESS_DIPS = 2;
    private static final byte DEFAULT_BOTTOM_BORDER_COLOR_ALPHA = 38;
    private static final int SELECTED_INDICATOR_THICKNESS_DIPS = 8;
    private static final int DEFAULT_SELECTED_INDICATOR_COLOR = -13388315;
    private static final float DEFAULT_INDICATOR_CORNER_RADIUS = 0.0f;
    private static final int DEFAULT_DIVIDER_THICKNESS_DIPS = 1;
    private static final byte DEFAULT_DIVIDER_COLOR_ALPHA = 32;
    private static final float DEFAULT_DIVIDER_HEIGHT = 0.5f;
    private static final boolean DEFAULT_INDICATOR_IN_CENTER = false;
    private static final boolean DEFAULT_INDICATOR_IN_FRONT = false;
    private static final boolean DEFAULT_INDICATOR_WITHOUT_PADDING = false;
    private static final int DEFAULT_INDICATOR_GRAVITY = 0;
    private final int topBorderThickness;
    private final int topBorderColor;
    private final int bottomBorderThickness;
    private final int bottomBorderColor;
    private final Paint borderPaint;
    private final RectF indicatorRectF = new RectF();
    private final boolean indicatorWithoutPadding;
    private final boolean indicatorAlwaysInCenter;
    private final boolean indicatorInFront;
    private final int indicatorThickness;
    private final int indicatorGravity;
    private final float indicatorCornerRadius;
    private final Paint indicatorPaint;
    private final int dividerThickness;
    private final Paint dividerPaint;
    private final float dividerHeight;
    private final SimpleTabColorizer defaultTabColorizer;
    private int lastPosition;
    private int selectedPosition;
    private float selectionOffset;
    private SmartTabIndicationInterpolator indicationInterpolator;
    private SmartTabLayout.TabColorizer customTabColorizer;

    SmartTabStrip(Context context, AttributeSet attrs) {
        super(context);
        int[] nArray;
        int[] indicatorColors;
        int[] nArray2;
        this.setWillNotDraw(false);
        float density = this.getResources().getDisplayMetrics().density;
        TypedValue outValue = new TypedValue();
        context.getTheme().resolveAttribute(0x1010030, outValue, true);
        int themeForegroundColor = outValue.data;
        boolean indicatorWithoutPadding = false;
        boolean indicatorInFront = false;
        boolean indicatorAlwaysInCenter = false;
        int indicationInterpolatorId = 0;
        int indicatorGravity = 0;
        int indicatorColor = -13388315;
        int indicatorColorsId = -1;
        int indicatorThickness = (int)(8.0f * density);
        float indicatorCornerRadius = 0.0f * density;
        int overlineColor = SmartTabStrip.setColorAlpha(themeForegroundColor, (byte)38);
        int overlineThickness = (int)(0.0f * density);
        int underlineColor = SmartTabStrip.setColorAlpha(themeForegroundColor, (byte)38);
        int underlineThickness = (int)(2.0f * density);
        int dividerColor = SmartTabStrip.setColorAlpha(themeForegroundColor, (byte)32);
        int dividerColorsId = -1;
        int dividerThickness = (int)(1.0f * density);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.stl_SmartTabLayout);
        indicatorAlwaysInCenter = a.getBoolean(R.styleable.stl_SmartTabLayout_stl_indicatorAlwaysInCenter, indicatorAlwaysInCenter);
        indicatorWithoutPadding = a.getBoolean(R.styleable.stl_SmartTabLayout_stl_indicatorWithoutPadding, indicatorWithoutPadding);
        indicatorInFront = a.getBoolean(R.styleable.stl_SmartTabLayout_stl_indicatorInFront, indicatorInFront);
        indicationInterpolatorId = a.getInt(R.styleable.stl_SmartTabLayout_stl_indicatorInterpolation, indicationInterpolatorId);
        indicatorGravity = a.getInt(R.styleable.stl_SmartTabLayout_stl_indicatorGravity, indicatorGravity);
        indicatorColor = a.getColor(R.styleable.stl_SmartTabLayout_stl_indicatorColor, indicatorColor);
        indicatorColorsId = a.getResourceId(R.styleable.stl_SmartTabLayout_stl_indicatorColors, indicatorColorsId);
        indicatorThickness = a.getDimensionPixelSize(R.styleable.stl_SmartTabLayout_stl_indicatorThickness, indicatorThickness);
        indicatorCornerRadius = a.getDimension(R.styleable.stl_SmartTabLayout_stl_indicatorCornerRadius, indicatorCornerRadius);
        overlineColor = a.getColor(R.styleable.stl_SmartTabLayout_stl_overlineColor, overlineColor);
        overlineThickness = a.getDimensionPixelSize(R.styleable.stl_SmartTabLayout_stl_overlineThickness, overlineThickness);
        underlineColor = a.getColor(R.styleable.stl_SmartTabLayout_stl_underlineColor, underlineColor);
        underlineThickness = a.getDimensionPixelSize(R.styleable.stl_SmartTabLayout_stl_underlineThickness, underlineThickness);
        dividerColor = a.getColor(R.styleable.stl_SmartTabLayout_stl_dividerColor, dividerColor);
        dividerColorsId = a.getResourceId(R.styleable.stl_SmartTabLayout_stl_dividerColors, dividerColorsId);
        dividerThickness = a.getDimensionPixelSize(R.styleable.stl_SmartTabLayout_stl_dividerThickness, dividerThickness);
        a.recycle();
        if (indicatorColorsId == -1) {
            int[] nArray3 = new int[1];
            nArray2 = nArray3;
            nArray3[0] = indicatorColor;
        } else {
            nArray2 = indicatorColors = this.getResources().getIntArray(indicatorColorsId);
        }
        if (dividerColorsId == -1) {
            int[] nArray4 = new int[1];
            nArray = nArray4;
            nArray4[0] = dividerColor;
        } else {
            nArray = this.getResources().getIntArray(dividerColorsId);
        }
        int[] dividerColors = nArray;
        this.defaultTabColorizer = new SimpleTabColorizer();
        this.defaultTabColorizer.setIndicatorColors(indicatorColors);
        this.defaultTabColorizer.setDividerColors(dividerColors);
        this.topBorderThickness = overlineThickness;
        this.topBorderColor = overlineColor;
        this.bottomBorderThickness = underlineThickness;
        this.bottomBorderColor = underlineColor;
        this.borderPaint = new Paint(1);
        this.indicatorAlwaysInCenter = indicatorAlwaysInCenter;
        this.indicatorWithoutPadding = indicatorWithoutPadding;
        this.indicatorInFront = indicatorInFront;
        this.indicatorThickness = indicatorThickness;
        this.indicatorPaint = new Paint(1);
        this.indicatorCornerRadius = indicatorCornerRadius;
        this.indicatorGravity = indicatorGravity;
        this.dividerHeight = 0.5f;
        this.dividerPaint = new Paint(1);
        this.dividerPaint.setStrokeWidth((float)dividerThickness);
        this.dividerThickness = dividerThickness;
        this.indicationInterpolator = SmartTabIndicationInterpolator.of(indicationInterpolatorId);
    }

    private static int setColorAlpha(int color, byte alpha) {
        return Color.argb((int)alpha, (int)Color.red((int)color), (int)Color.green((int)color), (int)Color.blue((int)color));
    }

    private static int blendColors(int color1, int color2, float ratio) {
        float inverseRation = 1.0f - ratio;
        float r = (float)Color.red((int)color1) * ratio + (float)Color.red((int)color2) * inverseRation;
        float g = (float)Color.green((int)color1) * ratio + (float)Color.green((int)color2) * inverseRation;
        float b = (float)Color.blue((int)color1) * ratio + (float)Color.blue((int)color2) * inverseRation;
        return Color.rgb((int)((int)r), (int)((int)g), (int)((int)b));
    }

    void setIndicationInterpolator(SmartTabIndicationInterpolator interpolator) {
        this.indicationInterpolator = interpolator;
        this.invalidate();
    }

    void setCustomTabColorizer(SmartTabLayout.TabColorizer customTabColorizer) {
        this.customTabColorizer = customTabColorizer;
        this.invalidate();
    }

    void setSelectedIndicatorColors(int ... colors) {
        this.customTabColorizer = null;
        this.defaultTabColorizer.setIndicatorColors(colors);
        this.invalidate();
    }

    void setDividerColors(int ... colors) {
        this.customTabColorizer = null;
        this.defaultTabColorizer.setDividerColors(colors);
        this.invalidate();
    }

    void onViewPagerPageChanged(int position, float positionOffset) {
        this.selectedPosition = position;
        this.selectionOffset = positionOffset;
        if (positionOffset == 0.0f && this.lastPosition != this.selectedPosition) {
            this.lastPosition = this.selectedPosition;
        }
        this.invalidate();
    }

    boolean isIndicatorAlwaysInCenter() {
        return this.indicatorAlwaysInCenter;
    }

    SmartTabLayout.TabColorizer getTabColorizer() {
        return this.customTabColorizer != null ? this.customTabColorizer : this.defaultTabColorizer;
    }

    protected void onDraw(Canvas canvas) {
        int height = this.getHeight();
        int width = this.getWidth();
        int tabCount = this.getChildCount();
        SmartTabLayout.TabColorizer tabColorizer = this.getTabColorizer();
        boolean isLayoutRtl = Utils.isLayoutRtl((View)this);
        if (this.indicatorInFront) {
            this.drawOverline(canvas, 0, width);
            this.drawUnderline(canvas, 0, width, height);
        }
        if (tabCount > 0) {
            int right;
            int left;
            View selectedTab = this.getChildAt(this.selectedPosition);
            int selectedStart = Utils.getStart(selectedTab, this.indicatorWithoutPadding);
            int selectedEnd = Utils.getEnd(selectedTab, this.indicatorWithoutPadding);
            if (isLayoutRtl) {
                left = selectedEnd;
                right = selectedStart;
            } else {
                left = selectedStart;
                right = selectedEnd;
            }
            int color = tabColorizer.getIndicatorColor(this.selectedPosition);
            float thickness = this.indicatorThickness;
            if (this.selectionOffset > 0.0f && this.selectedPosition < this.getChildCount() - 1) {
                int nextColor = tabColorizer.getIndicatorColor(this.selectedPosition + 1);
                if (color != nextColor) {
                    color = SmartTabStrip.blendColors(nextColor, color, this.selectionOffset);
                }
                float startOffset = this.indicationInterpolator.getLeftEdge(this.selectionOffset);
                float endOffset = this.indicationInterpolator.getRightEdge(this.selectionOffset);
                float thicknessOffset = this.indicationInterpolator.getThickness(this.selectionOffset);
                View nextTab = this.getChildAt(this.selectedPosition + 1);
                int nextStart = Utils.getStart(nextTab, this.indicatorWithoutPadding);
                int nextEnd = Utils.getEnd(nextTab, this.indicatorWithoutPadding);
                if (isLayoutRtl) {
                    left = (int)(endOffset * (float)nextEnd + (1.0f - endOffset) * (float)left);
                    right = (int)(startOffset * (float)nextStart + (1.0f - startOffset) * (float)right);
                } else {
                    left = (int)(startOffset * (float)nextStart + (1.0f - startOffset) * (float)left);
                    right = (int)(endOffset * (float)nextEnd + (1.0f - endOffset) * (float)right);
                }
                thickness *= thicknessOffset;
            }
            this.drawIndicator(canvas, left, right, height, thickness, color);
        }
        if (!this.indicatorInFront) {
            this.drawOverline(canvas, 0, width);
            this.drawUnderline(canvas, 0, this.getWidth(), height);
        }
        this.drawSeparator(canvas, height, tabCount);
    }

    private void drawSeparator(Canvas canvas, int height, int tabCount) {
        if (this.dividerThickness <= 0) {
            return;
        }
        int dividerHeightPx = (int)(Math.min(Math.max(0.0f, this.dividerHeight), 1.0f) * (float)height);
        SmartTabLayout.TabColorizer tabColorizer = this.getTabColorizer();
        int separatorTop = (height - dividerHeightPx) / 2;
        int separatorBottom = separatorTop + dividerHeightPx;
        boolean isLayoutRtl = Utils.isLayoutRtl((View)this);
        for (int i = 0; i < tabCount - 1; ++i) {
            View child = this.getChildAt(i);
            int end = Utils.getEnd(child);
            int endMargin = Utils.getMarginEnd(child);
            int separatorX = isLayoutRtl ? end - endMargin : end + endMargin;
            this.dividerPaint.setColor(tabColorizer.getDividerColor(i));
            canvas.drawLine((float)separatorX, (float)separatorTop, (float)separatorX, (float)separatorBottom, this.dividerPaint);
        }
    }

    private void drawIndicator(Canvas canvas, int left, int right, int height, float thickness, int color) {
        float bottom;
        float top;
        if (this.indicatorThickness <= 0) {
            return;
        }
        switch (this.indicatorGravity) {
            case 1: {
                float center = (float)this.indicatorThickness / 2.0f;
                top = center - thickness / 2.0f;
                bottom = center + thickness / 2.0f;
                break;
            }
            case 2: {
                float center = (float)height / 2.0f;
                top = center - thickness / 2.0f;
                bottom = center + thickness / 2.0f;
                break;
            }
            default: {
                float center = (float)height - (float)this.indicatorThickness / 2.0f;
                top = center - thickness / 2.0f;
                bottom = center + thickness / 2.0f;
            }
        }
        this.indicatorPaint.setColor(color);
        this.indicatorRectF.set((float)left, top, (float)right, bottom);
        if (this.indicatorCornerRadius > 0.0f) {
            canvas.drawRoundRect(this.indicatorRectF, this.indicatorCornerRadius, this.indicatorCornerRadius, this.indicatorPaint);
        } else {
            canvas.drawRect(this.indicatorRectF, this.indicatorPaint);
        }
    }

    private void drawOverline(Canvas canvas, int left, int right) {
        if (this.topBorderThickness <= 0) {
            return;
        }
        this.borderPaint.setColor(this.topBorderColor);
        canvas.drawRect((float)left, 0.0f, (float)right, (float)this.topBorderThickness, this.borderPaint);
    }

    private void drawUnderline(Canvas canvas, int left, int right, int height) {
        if (this.bottomBorderThickness <= 0) {
            return;
        }
        this.borderPaint.setColor(this.bottomBorderColor);
        canvas.drawRect((float)left, (float)(height - this.bottomBorderThickness), (float)right, (float)height, this.borderPaint);
    }

    private static class SimpleTabColorizer
    implements SmartTabLayout.TabColorizer {
        private int[] indicatorColors;
        private int[] dividerColors;

        private SimpleTabColorizer() {
        }

        @Override
        public final int getIndicatorColor(int position) {
            return this.indicatorColors[position % this.indicatorColors.length];
        }

        @Override
        public final int getDividerColor(int position) {
            return this.dividerColors[position % this.dividerColors.length];
        }

        void setIndicatorColors(int ... colors) {
            this.indicatorColors = colors;
        }

        void setDividerColors(int ... colors) {
            this.dividerColors = colors;
        }
    }
}

