/*
 * Decompiled with CFR 0.152.
 */
package com.ogaclejapan.smarttablayout;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.View;
import android.widget.LinearLayout;
import com.ogaclejapan.smarttablayout.R;
import com.ogaclejapan.smarttablayout.SmartTabIndicationInterpolator;
import com.ogaclejapan.smarttablayout.SmartTabLayout;

class SmartTabStrip
extends LinearLayout {
    private static final int DEFAULT_BOTTOM_BORDER_THICKNESS_DIPS = 2;
    private static final byte DEFAULT_BOTTOM_BORDER_COLOR_ALPHA = 38;
    private static final int SELECTED_INDICATOR_THICKNESS_DIPS = 8;
    private static final int DEFAULT_SELECTED_INDICATOR_COLOR = -13388315;
    private static final float DEFAULT_INDICATOR_CORNER_RADIUS = 0.0f;
    private static final int DEFAULT_DIVIDER_THICKNESS_DIPS = 1;
    private static final byte DEFAULT_DIVIDER_COLOR_ALPHA = 32;
    private static final float DEFAULT_DIVIDER_HEIGHT = 0.5f;
    private static final boolean DEFAULT_INDICATOR_IN_CENTER = false;
    private static final boolean DEFAULT_INDICATOR_IN_FRONT = false;
    private final int mBottomBorderThickness;
    private final Paint mBottomBorderPaint;
    private final RectF mIndicatorRectF = new RectF();
    private final boolean mIndicatorAlwaysInCenter;
    private final boolean mIndicatorInFront;
    private final int mIndicatorThickness;
    private final float mIndicatorCornerRadius;
    private final Paint mIndicatorPaint;
    private final Paint mDividerPaint;
    private final float mDividerHeight;
    private int mLastPosition;
    private int mSelectedPosition;
    private float mSelectionOffset;
    private SmartTabIndicationInterpolator mIndicationInterpolator;
    private SmartTabLayout.TabColorizer mCustomTabColorizer;
    private final SimpleTabColorizer mDefaultTabColorizer;

    SmartTabStrip(Context context, AttributeSet attrs) {
        super(context);
        int[] nArray;
        int[] indicatorColors;
        int[] nArray2;
        this.setWillNotDraw(false);
        float density = this.getResources().getDisplayMetrics().density;
        TypedValue outValue = new TypedValue();
        context.getTheme().resolveAttribute(0x1010030, outValue, true);
        int themeForegroundColor = outValue.data;
        boolean indicatorInFront = false;
        boolean indicatorAlwaysInCenter = false;
        int indicationInterpolatorId = 0;
        int indicatorColor = -13388315;
        int indicatorColorsId = -1;
        int indicatorThickness = (int)(8.0f * density);
        float indicatorCornerRadius = 0.0f * density;
        int underlineColor = SmartTabStrip.setColorAlpha(themeForegroundColor, (byte)38);
        int underlineThickness = (int)(2.0f * density);
        int dividerColor = SmartTabStrip.setColorAlpha(themeForegroundColor, (byte)32);
        int dividerColorsId = -1;
        int dividerThickness = (int)(1.0f * density);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.stl_SmartTabLayout);
        indicatorAlwaysInCenter = a.getBoolean(R.styleable.stl_SmartTabLayout_stl_indicatorAlwaysInCenter, indicatorAlwaysInCenter);
        indicatorInFront = a.getBoolean(R.styleable.stl_SmartTabLayout_stl_indicatorInFront, indicatorInFront);
        indicationInterpolatorId = a.getInt(R.styleable.stl_SmartTabLayout_stl_indicatorInterpolation, indicationInterpolatorId);
        indicatorColor = a.getColor(R.styleable.stl_SmartTabLayout_stl_indicatorColor, indicatorColor);
        indicatorColorsId = a.getResourceId(R.styleable.stl_SmartTabLayout_stl_indicatorColors, indicatorColorsId);
        indicatorThickness = a.getDimensionPixelSize(R.styleable.stl_SmartTabLayout_stl_indicatorThickness, indicatorThickness);
        indicatorCornerRadius = a.getDimension(R.styleable.stl_SmartTabLayout_stl_indicatorCornerRadius, indicatorCornerRadius);
        underlineColor = a.getColor(R.styleable.stl_SmartTabLayout_stl_underlineColor, underlineColor);
        underlineThickness = a.getDimensionPixelSize(R.styleable.stl_SmartTabLayout_stl_underlineThickness, underlineThickness);
        dividerColor = a.getColor(R.styleable.stl_SmartTabLayout_stl_dividerColor, dividerColor);
        dividerColorsId = a.getResourceId(R.styleable.stl_SmartTabLayout_stl_dividerColors, dividerColorsId);
        dividerThickness = a.getDimensionPixelSize(R.styleable.stl_SmartTabLayout_stl_dividerThickness, dividerThickness);
        a.recycle();
        if (indicatorColorsId == -1) {
            int[] nArray3 = new int[1];
            nArray2 = nArray3;
            nArray3[0] = indicatorColor;
        } else {
            nArray2 = indicatorColors = this.getResources().getIntArray(indicatorColorsId);
        }
        if (dividerColorsId == -1) {
            int[] nArray4 = new int[1];
            nArray = nArray4;
            nArray4[0] = dividerColor;
        } else {
            nArray = this.getResources().getIntArray(dividerColorsId);
        }
        int[] dividerColors = nArray;
        this.mDefaultTabColorizer = new SimpleTabColorizer();
        this.mDefaultTabColorizer.setIndicatorColors(indicatorColors);
        this.mDefaultTabColorizer.setDividerColors(dividerColors);
        this.mBottomBorderThickness = underlineThickness;
        this.mBottomBorderPaint = new Paint(1);
        this.mBottomBorderPaint.setColor(underlineColor);
        this.mIndicatorAlwaysInCenter = indicatorAlwaysInCenter;
        this.mIndicatorInFront = indicatorInFront;
        this.mIndicatorThickness = indicatorThickness;
        this.mIndicatorPaint = new Paint(1);
        this.mIndicatorCornerRadius = indicatorCornerRadius;
        this.mDividerHeight = 0.5f;
        this.mDividerPaint = new Paint(1);
        this.mDividerPaint.setStrokeWidth((float)dividerThickness);
        this.mIndicationInterpolator = SmartTabIndicationInterpolator.of(indicationInterpolatorId);
    }

    void setIndicationInterpolator(SmartTabIndicationInterpolator interpolator) {
        this.mIndicationInterpolator = interpolator;
        this.invalidate();
    }

    void setCustomTabColorizer(SmartTabLayout.TabColorizer customTabColorizer) {
        this.mCustomTabColorizer = customTabColorizer;
        this.invalidate();
    }

    void setSelectedIndicatorColors(int ... colors) {
        this.mCustomTabColorizer = null;
        this.mDefaultTabColorizer.setIndicatorColors(colors);
        this.invalidate();
    }

    void setDividerColors(int ... colors) {
        this.mCustomTabColorizer = null;
        this.mDefaultTabColorizer.setDividerColors(colors);
        this.invalidate();
    }

    void onViewPagerPageChanged(int position, float positionOffset) {
        this.mSelectedPosition = position;
        this.mSelectionOffset = positionOffset;
        if (positionOffset == 0.0f && this.mLastPosition != this.mSelectedPosition) {
            this.mLastPosition = this.mSelectedPosition;
        }
        this.invalidate();
    }

    boolean isIndicatorAlwaysInCenter() {
        return this.mIndicatorAlwaysInCenter;
    }

    int getChildMeasuredWidthAt(int index) {
        return this.getChildAt(index).getMeasuredWidth();
    }

    int getChildWidthAt(int index) {
        return this.getChildAt(index).getWidth();
    }

    protected void onDraw(Canvas canvas) {
        SmartTabLayout.TabColorizer tabColorizer;
        int height = this.getHeight();
        int childCount = this.getChildCount();
        int dividerHeightPx = (int)(Math.min(Math.max(0.0f, this.mDividerHeight), 1.0f) * (float)height);
        SmartTabLayout.TabColorizer tabColorizer2 = tabColorizer = this.mCustomTabColorizer != null ? this.mCustomTabColorizer : this.mDefaultTabColorizer;
        if (this.mIndicatorInFront) {
            canvas.drawRect(0.0f, (float)(height - this.mBottomBorderThickness), (float)this.getWidth(), (float)height, this.mBottomBorderPaint);
        }
        if (childCount > 0) {
            View selectedTitle = this.getChildAt(this.mSelectedPosition);
            int left = selectedTitle.getLeft();
            int right = selectedTitle.getRight();
            int color = tabColorizer.getIndicatorColor(this.mSelectedPosition);
            float thickness = this.mIndicatorThickness;
            if (this.mSelectionOffset > 0.0f && this.mSelectedPosition < this.getChildCount() - 1) {
                int nextColor = tabColorizer.getIndicatorColor(this.mSelectedPosition + 1);
                if (color != nextColor) {
                    color = SmartTabStrip.blendColors(nextColor, color, this.mSelectionOffset);
                }
                float leftOffset = this.mIndicationInterpolator.getLeftEdge(this.mSelectionOffset);
                float rightOffset = this.mIndicationInterpolator.getRightEdge(this.mSelectionOffset);
                float thicknessOffset = this.mIndicationInterpolator.getThickness(this.mSelectionOffset);
                View nextTitle = this.getChildAt(this.mSelectedPosition + 1);
                left = (int)(leftOffset * (float)nextTitle.getLeft() + (1.0f - leftOffset) * (float)left);
                right = (int)(rightOffset * (float)nextTitle.getRight() + (1.0f - rightOffset) * (float)right);
                thickness *= thicknessOffset;
            }
            this.mIndicatorPaint.setColor(color);
            this.mIndicatorRectF.set((float)left, (float)height - (float)this.mIndicatorThickness / 2.0f - thickness / 2.0f, (float)right, (float)height - (float)this.mIndicatorThickness / 2.0f + thickness / 2.0f);
            if (this.mIndicatorCornerRadius > 0.0f) {
                canvas.drawRoundRect(this.mIndicatorRectF, this.mIndicatorCornerRadius, this.mIndicatorCornerRadius, this.mIndicatorPaint);
            } else {
                canvas.drawRect(this.mIndicatorRectF, this.mIndicatorPaint);
            }
        }
        if (!this.mIndicatorInFront) {
            canvas.drawRect(0.0f, (float)(height - this.mBottomBorderThickness), (float)this.getWidth(), (float)height, this.mBottomBorderPaint);
        }
        int separatorTop = (height - dividerHeightPx) / 2;
        for (int i = 0; i < childCount - 1; ++i) {
            View child = this.getChildAt(i);
            this.mDividerPaint.setColor(tabColorizer.getDividerColor(i));
            canvas.drawLine((float)child.getRight(), (float)separatorTop, (float)child.getRight(), (float)(separatorTop + dividerHeightPx), this.mDividerPaint);
        }
    }

    private static int setColorAlpha(int color, byte alpha) {
        return Color.argb((int)alpha, (int)Color.red((int)color), (int)Color.green((int)color), (int)Color.blue((int)color));
    }

    private static int blendColors(int color1, int color2, float ratio) {
        float inverseRation = 1.0f - ratio;
        float r = (float)Color.red((int)color1) * ratio + (float)Color.red((int)color2) * inverseRation;
        float g = (float)Color.green((int)color1) * ratio + (float)Color.green((int)color2) * inverseRation;
        float b = (float)Color.blue((int)color1) * ratio + (float)Color.blue((int)color2) * inverseRation;
        return Color.rgb((int)((int)r), (int)((int)g), (int)((int)b));
    }

    private static class SimpleTabColorizer
    implements SmartTabLayout.TabColorizer {
        private int[] mIndicatorColors;
        private int[] mDividerColors;

        private SimpleTabColorizer() {
        }

        @Override
        public final int getIndicatorColor(int position) {
            return this.mIndicatorColors[position % this.mIndicatorColors.length];
        }

        @Override
        public final int getDividerColor(int position) {
            return this.mDividerColors[position % this.mDividerColors.length];
        }

        void setIndicatorColors(int ... colors) {
            this.mIndicatorColors = colors;
        }

        void setDividerColors(int ... colors) {
            this.mDividerColors = colors;
        }
    }
}

