/*
 * Decompiled with CFR 0.152.
 */
package com.octo.android.robospice.persistence.springandroid;

import android.app.Application;
import com.octo.android.robospice.persistence.exception.CacheCreationException;
import com.octo.android.robospice.persistence.exception.CacheLoadingException;
import com.octo.android.robospice.persistence.exception.CacheSavingException;
import com.octo.android.robospice.persistence.file.InFileObjectPersister;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import roboguice.util.temp.Ln;

public abstract class SpringAndroidObjectPersister<T>
extends InFileObjectPersister<T> {
    public SpringAndroidObjectPersister(Application application, Class<T> clazz, File cacheFolder) throws CacheCreationException {
        super(application, clazz, cacheFolder);
    }

    public SpringAndroidObjectPersister(Application application, Class<T> clazz) throws CacheCreationException {
        super(application, clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T readCacheDataFromFile(File file) throws CacheLoadingException {
        try {
            String resultJson = null;
            String string = file.getAbsolutePath().intern();
            synchronized (string) {
                resultJson = FileUtils.readFileToString((File)file, (String)"UTF-8");
            }
            if (!StringUtils.isEmpty((CharSequence)resultJson)) {
                T result = this.deserializeData(resultJson);
                return result;
            }
            throw new CacheLoadingException("Unable to restore cache content : cache file is empty");
        }
        catch (FileNotFoundException e) {
            Ln.w((Object)("file " + file.getAbsolutePath() + " does not exists"), (Object[])new Object[]{e});
            return null;
        }
        catch (CacheLoadingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CacheLoadingException((Throwable)e);
        }
    }

    protected abstract T deserializeData(String var1) throws CacheLoadingException;

    public T saveDataToCacheAndReturnData(final T data, final Object cacheKey) throws CacheSavingException {
        try {
            if (this.isAsyncSaveEnabled()) {
                Thread t = new Thread(){

                    @Override
                    public void run() {
                        try {
                            SpringAndroidObjectPersister.this.saveData(data, cacheKey);
                        }
                        catch (IOException e) {
                            Ln.e((Throwable)e, (Object)("An error occured on saving request " + cacheKey + " data asynchronously"), (Object[])new Object[0]);
                        }
                        catch (CacheSavingException e) {
                            Ln.e((Throwable)e, (Object)("An error occured on saving request " + cacheKey + " data asynchronously"), (Object[])new Object[0]);
                        }
                    }
                };
                t.start();
            } else {
                this.saveData(data, cacheKey);
            }
        }
        catch (CacheSavingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CacheSavingException((Throwable)e);
        }
        return data;
    }

    protected abstract void saveData(T var1, Object var2) throws IOException, CacheSavingException;
}

