/*
 * Decompiled with CFR 0.152.
 */
package roboguice.util.temp;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class Strings {
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    private Strings() {
    }

    public static <T> String joinAnd(String delimiter, String lastDelimiter, Collection<T> objs) {
        if (objs == null || objs.isEmpty()) {
            return "";
        }
        Iterator<T> iter = objs.iterator();
        StringBuilder buffer = new StringBuilder(Strings.toString(iter.next()));
        int i = 1;
        while (iter.hasNext()) {
            T obj = iter.next();
            if (!Strings.notEmpty(obj)) continue;
            buffer.append(++i == objs.size() ? lastDelimiter : delimiter).append(Strings.toString(obj));
        }
        return buffer.toString();
    }

    public static <T> String joinAnd(String delimiter, String lastDelimiter, T ... objs) {
        return Strings.joinAnd(delimiter, lastDelimiter, Arrays.asList(objs));
    }

    public static <T> String join(String delimiter, Collection<T> objs) {
        if (objs == null || objs.isEmpty()) {
            return "";
        }
        Iterator<T> iter = objs.iterator();
        StringBuilder buffer = new StringBuilder(Strings.toString(iter.next()));
        while (iter.hasNext()) {
            T obj = iter.next();
            if (!Strings.notEmpty(obj)) continue;
            buffer.append(delimiter).append(Strings.toString(obj));
        }
        return buffer.toString();
    }

    public static <T> String join(String delimiter, T ... objects) {
        return Strings.join(delimiter, Arrays.asList(objects));
    }

    public static String toString(InputStream input) {
        StringWriter sw = new StringWriter();
        Strings.copy(new InputStreamReader(input, Charset.forName("UTF-8")), sw);
        return sw.toString();
    }

    public static String toString(Reader input) {
        StringWriter sw = new StringWriter();
        Strings.copy(input, sw);
        return sw.toString();
    }

    public static int copy(Reader input, Writer output) {
        long count = Strings.copyLarge(input, output);
        return count > Integer.MAX_VALUE ? -1 : (int)count;
    }

    public static long copyLarge(Reader input, Writer output) {
        try {
            int n;
            char[] buffer = new char[4096];
            long count = 0L;
            while (-1 != (n = input.read(buffer))) {
                output.write(buffer, 0, n);
                count += (long)n;
            }
            return count;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String toString(Object o) {
        return Strings.toString(o, "");
    }

    public static String toString(Object o, String def) {
        return o == null ? def : (o instanceof InputStream ? Strings.toString((InputStream)o) : (o instanceof Reader ? Strings.toString((Reader)o) : (o instanceof Object[] ? Strings.join(", ", (Object[])o) : (o instanceof Collection ? Strings.join(", ", (Collection)o) : o.toString()))));
    }

    public static boolean isEmpty(Object o) {
        return Strings.toString(o).trim().length() == 0;
    }

    public static boolean notEmpty(Object o) {
        return Strings.toString(o).trim().length() != 0;
    }

    public static String md5(String s) {
        try {
            byte[] hash = MessageDigest.getInstance("MD5").digest(s.getBytes("UTF-8"));
            StringBuilder hashString = new StringBuilder();
            for (byte aHash : hash) {
                String hex = Integer.toHexString(aHash);
                if (hex.length() == 1) {
                    hashString.append('0');
                    hashString.append(hex.charAt(hex.length() - 1));
                    continue;
                }
                hashString.append(hex.substring(hex.length() - 2));
            }
            return hashString.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String capitalize(String s) {
        String c = Strings.toString(s);
        return c.length() >= 2 ? c.substring(0, 1).toUpperCase() + c.substring(1) : (c.length() >= 1 ? c.toUpperCase() : c);
    }

    public static boolean equals(Object a, Object b) {
        return Strings.toString(a).equals(Strings.toString(b));
    }

    public static boolean equalsIgnoreCase(Object a, Object b) {
        return Strings.toString(a).toLowerCase().equals(Strings.toString(b).toLowerCase());
    }

    public static String[] chunk(String str, int chunkSize) {
        if (Strings.isEmpty(str) || chunkSize == 0) {
            return new String[0];
        }
        int len = str.length();
        int arrayLen = (len - 1) / chunkSize + 1;
        String[] array = new String[arrayLen];
        for (int i = 0; i < arrayLen; ++i) {
            array[i] = str.substring(i * chunkSize, i * chunkSize + chunkSize < len ? i * chunkSize + chunkSize : len);
        }
        return array;
    }

    public static String namedFormat(String str, Map<String, String> substitutions) {
        for (Map.Entry<String, String> entry : substitutions.entrySet()) {
            str = str.replace('$' + entry.getKey(), entry.getValue());
        }
        return str;
    }

    public static String namedFormat(String str, Object ... nameValuePairs) {
        if (nameValuePairs.length % 2 != 0) {
            throw new InvalidParameterException("You must include one value for each parameter");
        }
        HashMap<String, String> map = new HashMap<String, String>(nameValuePairs.length / 2);
        for (int i = 0; i < nameValuePairs.length; i += 2) {
            map.put(Strings.toString(nameValuePairs[i]), Strings.toString(nameValuePairs[i + 1]));
        }
        return Strings.namedFormat(str, map);
    }
}

