/*
 * Decompiled with CFR 0.152.
 */
package com.octo.android.robospice.persistence.keysanitation;

import android.annotation.TargetApi;
import android.util.Base64;
import com.octo.android.robospice.persistence.exception.KeySanitationExcepion;
import com.octo.android.robospice.persistence.keysanitation.KeySanitizer;
import java.io.UnsupportedEncodingException;

@TargetApi(value=8)
public class DefaultKeySanitizer
implements KeySanitizer {
    private static final int BASE64_FLAGS = 11;
    private static final String UTF8_CHARSET_NAME = "UTF-8";

    @Override
    public Object sanitizeKey(Object cacheKey) throws KeySanitationExcepion {
        if (!(cacheKey instanceof String)) {
            throw new KeySanitationExcepion(DefaultKeySanitizer.class.getSimpleName() + " can only be used with Strings cache keys.");
        }
        try {
            return Base64.encodeToString((byte[])((String)cacheKey).getBytes(UTF8_CHARSET_NAME), (int)11);
        }
        catch (UnsupportedEncodingException e) {
            throw new KeySanitationExcepion(e);
        }
    }

    @Override
    public Object desanitizeKey(Object sanitzedCacheKey) throws KeySanitationExcepion {
        if (!(sanitzedCacheKey instanceof String)) {
            throw new KeySanitationExcepion(DefaultKeySanitizer.class.getSimpleName() + " can only be used with Strings cache keys.");
        }
        try {
            return new String(Base64.decode((String)((String)sanitzedCacheKey), (int)11), UTF8_CHARSET_NAME);
        }
        catch (UnsupportedEncodingException e) {
            throw new KeySanitationExcepion(e);
        }
    }
}

