/*
 * Decompiled with CFR 0.152.
 */
package com.octo.android.robospice.persistence.binary;

import android.app.Application;
import com.octo.android.robospice.persistence.exception.CacheCreationException;
import com.octo.android.robospice.persistence.exception.CacheLoadingException;
import com.octo.android.robospice.persistence.exception.CacheSavingException;
import com.octo.android.robospice.persistence.file.InFileObjectPersister;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import roboguice.util.temp.Ln;

public class InFileInputStreamObjectPersister
extends InFileObjectPersister<InputStream> {
    public InFileInputStreamObjectPersister(Application application) throws CacheCreationException {
        super(application, InputStream.class);
    }

    public InFileInputStreamObjectPersister(Application application, File cacheFolder) throws CacheCreationException {
        super(application, InputStream.class, cacheFolder);
    }

    @Override
    protected InputStream readCacheDataFromFile(File file) throws CacheLoadingException {
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            Ln.w("file " + file.getAbsolutePath() + " does not exists", e);
            return null;
        }
    }

    @Override
    public InputStream saveDataToCacheAndReturnData(InputStream data, final Object cacheKey) throws CacheSavingException {
        try {
            final byte[] byteArray = IOUtils.toByteArray((InputStream)data);
            if (this.isAsyncSaveEnabled()) {
                Thread t = new Thread(){

                    @Override
                    public void run() {
                        try {
                            FileUtils.writeByteArrayToFile((File)InFileInputStreamObjectPersister.this.getCacheFile(cacheKey), (byte[])byteArray);
                        }
                        catch (IOException e) {
                            Ln.e(e, (Object)("An error occured on saving request " + cacheKey + " data asynchronously"), new Object[0]);
                        }
                    }
                };
                t.start();
            } else {
                FileUtils.writeByteArrayToFile((File)this.getCacheFile(cacheKey), (byte[])byteArray);
            }
            return new ByteArrayInputStream(byteArray);
        }
        catch (IOException e) {
            throw new CacheSavingException(e);
        }
    }

    @Override
    public boolean canHandleClass(Class<?> clazz) {
        try {
            clazz.asSubclass(InputStream.class);
            return true;
        }
        catch (ClassCastException ex) {
            return false;
        }
    }
}

