/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.clogproxy.client.config;

import com.oceanbase.clogproxy.client.util.ClientIdGenerator;
import com.oceanbase.clogproxy.common.config.SharedConf;
import io.netty.handler.ssl.SslContext;
import java.io.Serializable;

public class ClientConf
extends SharedConf
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String VERSION = "1.0.5";
    private final int transferQueueSize;
    private final int connectTimeoutMs;
    private final int readWaitTimeMs;
    private final int retryIntervalS;
    private final int idleTimeoutS;
    private final int maxReconnectTimes;
    private final int nettyDiscardAfterReads;
    private final String clientId;
    private final boolean ignoreUnknownRecordType;
    private final SslContext sslContext;

    private ClientConf(int transferQueueSize, int connectTimeoutMs, int readWaitTimeMs, int retryIntervalS, int maxReconnectTimes, int idleTimeoutS, int nettyDiscardAfterReads, String clientId, boolean ignoreUnknownRecordType, SslContext sslContext) {
        this.transferQueueSize = transferQueueSize;
        this.connectTimeoutMs = connectTimeoutMs;
        this.readWaitTimeMs = readWaitTimeMs;
        this.retryIntervalS = retryIntervalS;
        this.maxReconnectTimes = maxReconnectTimes;
        this.idleTimeoutS = idleTimeoutS;
        this.nettyDiscardAfterReads = nettyDiscardAfterReads;
        this.clientId = clientId;
        this.ignoreUnknownRecordType = ignoreUnknownRecordType;
        this.sslContext = sslContext;
    }

    public int getTransferQueueSize() {
        return this.transferQueueSize;
    }

    public int getConnectTimeoutMs() {
        return this.connectTimeoutMs;
    }

    public int getReadWaitTimeMs() {
        return this.readWaitTimeMs;
    }

    public int getRetryIntervalS() {
        return this.retryIntervalS;
    }

    public int getMaxReconnectTimes() {
        return this.maxReconnectTimes;
    }

    public int getIdleTimeoutS() {
        return this.idleTimeoutS;
    }

    public int getNettyDiscardAfterReads() {
        return this.nettyDiscardAfterReads;
    }

    public String getClientId() {
        return this.clientId;
    }

    public boolean isIgnoreUnknownRecordType() {
        return this.ignoreUnknownRecordType;
    }

    public SslContext getSslContext() {
        return this.sslContext;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private int transferQueueSize = 20000;
        private int connectTimeoutMs = 5000;
        private int readWaitTimeMs = 2000;
        private int retryIntervalS = 2;
        private int maxReconnectTimes = -1;
        private int idleTimeoutS = 15;
        private int nettyDiscardAfterReads = 16;
        private String clientId = ClientIdGenerator.generate();
        private boolean ignoreUnknownRecordType = false;
        private SslContext sslContext = null;

        public Builder transferQueueSize(int transferQueueSize) {
            this.transferQueueSize = transferQueueSize;
            return this;
        }

        public Builder connectTimeoutMs(int connectTimeoutMs) {
            this.connectTimeoutMs = connectTimeoutMs;
            return this;
        }

        public Builder readWaitTimeMs(int readWaitTimeMs) {
            this.readWaitTimeMs = readWaitTimeMs;
            return this;
        }

        public Builder retryIntervalS(int retryIntervalS) {
            this.retryIntervalS = retryIntervalS;
            return this;
        }

        public Builder maxReconnectTimes(int maxReconnectTimes) {
            this.maxReconnectTimes = maxReconnectTimes;
            return this;
        }

        public Builder idleTimeoutS(int idleTimeoutS) {
            this.idleTimeoutS = idleTimeoutS;
            return this;
        }

        public Builder nettyDiscardAfterReads(int nettyDiscardAfterReads) {
            this.nettyDiscardAfterReads = nettyDiscardAfterReads;
            return this;
        }

        public Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder ignoreUnknownRecordType(boolean ignoreUnknownRecordType) {
            this.ignoreUnknownRecordType = ignoreUnknownRecordType;
            return this;
        }

        public Builder sslContext(SslContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        public ClientConf build() {
            return new ClientConf(this.transferQueueSize, this.connectTimeoutMs, this.readWaitTimeMs, this.retryIntervalS, this.maxReconnectTimes, this.idleTimeoutS, this.nettyDiscardAfterReads, this.clientId, this.ignoreUnknownRecordType, this.sslContext);
        }
    }
}

