/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.clogproxy.client.config;

import com.oceanbase.clogproxy.client.config.ConnectionConfig;
import com.oceanbase.clogproxy.common.packet.LogType;
import com.oceanbase.clogproxy.common.util.TypeTrait;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractConnectionConfig
implements ConnectionConfig {
    protected final Map<String, ConfigItem<Object>> configs = new HashMap<String, ConfigItem<Object>>();
    protected final Map<String, String> extraConfigs = new HashMap<String, String>();

    public void setConfigs(Map<String, String> allConfigs) {
        if (allConfigs != null) {
            for (Map.Entry<String, String> entry : allConfigs.entrySet()) {
                if (!this.configs.containsKey(entry.getKey())) {
                    this.extraConfigs.put(entry.getKey(), entry.getValue());
                    continue;
                }
                this.set(entry.getKey(), entry.getValue());
            }
        }
    }

    public abstract LogType getLogType();

    public void setExtraConfigs(Map<String, String> extraConfigs) {
        this.extraConfigs.putAll(extraConfigs);
    }

    void set(String key, String val) {
        ConfigItem<Object> cs = this.configs.get(key);
        if (cs != null) {
            cs.fromString(val);
        }
    }

    public abstract boolean valid();

    protected class ConfigItem<T>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected String key;
        protected T val;

        public ConfigItem(String key, T val) {
            this.key = key;
            this.val = val;
            AbstractConnectionConfig.this.configs.put(key, this);
        }

        public void set(T val) {
            this.val = val;
        }

        public void fromString(String val) {
            this.val = TypeTrait.fromString((String)val, this.val.getClass());
        }

        public String toString() {
            return this.val.toString();
        }
    }
}

