/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.utils.file.IO;

import android.content.Context;
import android.content.res.AssetManager;
import android.util.Xml;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.droidplanner.services.android.impl.core.drone.profiles.VehicleProfile;
import org.droidplanner.services.android.impl.core.firmware.FirmwareType;
import org.droidplanner.services.android.impl.utils.file.AssetUtil;
import org.droidplanner.services.android.impl.utils.file.DirectoryPath;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class VehicleProfileReader {
    private static final String VEHICLEPROFILE_PATH = "VehicleProfiles";
    private static final String TAG_METADATATYPE = "ParameterMetadataType";
    private static final String TAG_DEFAULT = "Default";
    private static final String ATTR_WPNAV_SPEED = "wpNavSpeed";
    private static final String ATTR_MAX_ALTITUDE = "maxAltitude";
    private static final String ATTR_TYPE = "type";

    public static VehicleProfile load(Context context, FirmwareType vehicleType) {
        String fileName = (Object)((Object)vehicleType) + ".xml";
        String path = VEHICLEPROFILE_PATH + File.separator + fileName;
        try {
            VehicleProfile newProfile = new VehicleProfile();
            File file = new File(DirectoryPath.getPublicDataPath(context) + path);
            if (file.exists()) {
                VehicleProfileReader.loadProfileFromFile(newProfile, file);
            } else {
                VehicleProfileReader.loadProfileFromResources(context, fileName, path, newProfile);
            }
            return newProfile;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void loadProfileFromFile(VehicleProfile newProfile, File file) throws FileNotFoundException, XmlPullParserException, IOException {
        FileInputStream inputStream = new FileInputStream(file);
        VehicleProfileReader.open(inputStream, newProfile);
    }

    private static void loadProfileFromResources(Context context, String fileName, String path, VehicleProfile newProfile) throws IOException, XmlPullParserException {
        AssetManager assetManager = context.getAssets();
        if (AssetUtil.exists(assetManager, VEHICLEPROFILE_PATH, fileName)) {
            InputStream inputStream = assetManager.open(path);
            VehicleProfileReader.open(inputStream, newProfile);
        }
    }

    private static void open(InputStream inputStream, VehicleProfile profile) throws XmlPullParserException, IOException {
        try {
            XmlPullParser parser = Xml.newPullParser();
            parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", false);
            parser.setInput(inputStream, null);
            VehicleProfileReader.parse(parser, profile);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static void parse(XmlPullParser parser, VehicleProfile profile) throws XmlPullParserException, IOException {
        int eventType = parser.getEventType();
        while (eventType != 1) {
            String parserName = parser.getName();
            switch (eventType) {
                case 2: {
                    if (parserName.equals(TAG_METADATATYPE)) {
                        String value = parser.getAttributeValue(null, ATTR_TYPE);
                        if (value == null) break;
                        profile.setParameterMetadataType(value);
                        break;
                    }
                    if (!parserName.equals(TAG_DEFAULT)) break;
                    VehicleProfileReader.parseDefault(parser, profile.getDefault());
                    break;
                }
            }
            eventType = parser.next();
        }
    }

    private static void parseDefault(XmlPullParser parser, VehicleProfile.Default default_) {
        String value = parser.getAttributeValue(null, ATTR_WPNAV_SPEED);
        if (value != null) {
            default_.setWpNavSpeed(VehicleProfileReader.parseInt(value));
        }
        if ((value = parser.getAttributeValue(null, ATTR_MAX_ALTITUDE)) != null) {
            default_.setMaxAltitude(VehicleProfileReader.parseInt(value));
        }
    }

    private static int parseInt(String str) {
        if (str == null) {
            return 0;
        }
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }
}

