/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.utils.file.IO;

import android.content.Context;
import com.o3dr.android.client.utils.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.droidplanner.services.android.impl.core.survey.CameraInfo;
import org.droidplanner.services.android.impl.utils.file.IO.CameraInfoReader;

public class CameraInfoLoader {
    private static final String CAMERA_INFO_ASSESTS_FOLDER = "CameraInfo";
    private Context context;
    private HashMap<String, String> filesInSdCard = new HashMap();
    private HashMap<String, String> filesInAssets = new HashMap();

    public CameraInfoLoader(Context context) {
        this.context = context;
    }

    public CameraInfo openFile(String file) throws Exception {
        if (this.filesInSdCard.containsKey(file)) {
            return this.readSdCardFile(file);
        }
        if (this.filesInAssets.containsKey(file)) {
            return this.readAssetsFile(file);
        }
        throw new FileNotFoundException();
    }

    private CameraInfo readSdCardFile(String file) throws Exception {
        CameraInfoReader reader = new CameraInfoReader();
        FileInputStream inputStream = new FileInputStream(this.filesInSdCard.get(file));
        reader.openFile(inputStream);
        ((InputStream)inputStream).close();
        return reader.getCameraInfo();
    }

    private CameraInfo readAssetsFile(String file) throws Exception {
        CameraInfoReader reader = new CameraInfoReader();
        InputStream inputStream = this.context.getAssets().open(this.filesInAssets.get(file));
        reader.openFile(inputStream);
        inputStream.close();
        return reader.getCameraInfo();
    }

    public List<String> getCameraInfoList() {
        ArrayList<String> avaliableCameras = new ArrayList<String>();
        List<String> cameraInfoListFromStorage = this.getCameraInfoListFromStorage();
        avaliableCameras.addAll(cameraInfoListFromStorage);
        List<String> cameraInfoListFromAssets = this.getCameraInfoListFromAssets();
        avaliableCameras.addAll(cameraInfoListFromAssets);
        return avaliableCameras;
    }

    private List<String> getCameraInfoListFromAssets() {
        try {
            String[] list = this.context.getAssets().list(CAMERA_INFO_ASSESTS_FOLDER);
            this.filesInAssets.clear();
            for (String string2 : list) {
                this.filesInAssets.put(string2, "CameraInfo/" + string2);
            }
            return Arrays.asList(list);
        }
        catch (IOException e) {
            return new ArrayList<String>();
        }
    }

    private List<String> getCameraInfoListFromStorage() {
        ArrayList<String> filesName = new ArrayList<String>();
        this.filesInSdCard.clear();
        File[] filesList = FileUtils.getCameraInfoFileList(this.context);
        if (filesList != null && filesList.length > 0) {
            for (File file : filesList) {
                String filename = file.getName();
                filesName.add(filename);
                this.filesInSdCard.put(filename, file.getAbsolutePath());
            }
        }
        return filesName;
    }
}

