/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.utils.connection;

import android.net.Network;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.SocketFactory;
import org.droidplanner.services.android.impl.communication.model.DataLink;
import timber.log.Timber;

public class SshConnection {
    private static final String TAG = SshConnection.class.getSimpleName();
    private static final int CONNECTION_TIMEOUT = 15000;
    private static final String EXEC_CHANNEL_TYPE = "exec";
    private final JSch jsch = new JSch();
    private final String host;
    private final String username;
    private final String password;
    private final DataLink.DataLinkProvider linkProvider;

    public SshConnection(String host, String username, String password, DataLink.DataLinkProvider linkProvider) {
        this.host = host;
        this.username = username;
        this.password = password;
        this.linkProvider = linkProvider;
    }

    private Session getSession() throws JSchException {
        Network network;
        Session session = this.jsch.getSession(this.username, this.host);
        Bundle extras = this.linkProvider.getConnectionExtras();
        if (extras != null && !extras.isEmpty() && Build.VERSION.SDK_INT >= 21 && (network = (Network)extras.getParcelable("extra_network")) != null) {
            session.setSocketFactory((com.jcraft.jsch.SocketFactory)new SshSocketFactory(network.getSocketFactory()));
        }
        session.setConfig("StrictHostKeyChecking", "no");
        session.setPassword(this.password);
        session.connect(15000);
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ping() {
        Session session = null;
        try {
            session = this.getSession();
            boolean bl = true;
            return bl;
        }
        catch (JSchException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (session != null && session.isConnected()) {
                session.disconnect();
            }
        }
    }

    public String execute(String command) throws IOException {
        if (TextUtils.isEmpty((CharSequence)command)) {
            return null;
        }
        Session session = null;
        Channel execChannel = null;
        try {
            session = this.getSession();
            execChannel = session.openChannel(EXEC_CHANNEL_TYPE);
            ((ChannelExec)execChannel).setCommand(command);
            execChannel.setInputStream(null);
            InputStream in = execChannel.getInputStream();
            execChannel.connect(15000);
            int bufferSize = 1024;
            StringBuilder response = new StringBuilder();
            byte[] buffer = new byte[1024];
            while (true) {
                int dataSize;
                if (in.available() > 0 && (dataSize = in.read(buffer, 0, 1024)) >= 0) {
                    response.append(new String(buffer, 0, dataSize));
                    continue;
                }
                if (execChannel.isClosed() && in.available() <= 0) break;
            }
            Timber.d((String)("SSH command exit status: " + execChannel.getExitStatus()), (Object[])new Object[0]);
            String string2 = response.toString();
            return string2;
        }
        catch (JSchException e) {
            throw new IOException(e);
        }
        finally {
            if (execChannel != null && execChannel.isConnected()) {
                execChannel.disconnect();
            }
            if (session != null && session.isConnected()) {
                session.disconnect();
            }
        }
    }

    public boolean downloadFile(String localFile, String remoteFilePath) throws IOException {
        return this.downloadFile(localFile, remoteFilePath, null);
    }

    public boolean downloadFile(String localFile, String remoteFilePath, DownloadListener listener) throws IOException {
        if (localFile == null || remoteFilePath == null) {
            return false;
        }
        Session session = null;
        Object execChannel = null;
        FileOutputStream fos = null;
        OutputStream out = null;
        InputStream in = null;
        try {
            String prefix = null;
            if (new File(localFile).isDirectory()) {
                prefix = localFile + File.separator;
            }
            session = this.getSession();
            String command = "scp -f " + remoteFilePath;
            Channel channel = session.openChannel(EXEC_CHANNEL_TYPE);
            ((ChannelExec)channel).setCommand(command);
            out = channel.getOutputStream();
            in = channel.getInputStream();
            channel.connect();
            byte[] buf = new byte[1024];
            buf[0] = 0;
            out.write(buf, 0, 1);
            out.flush();
            int c = SshConnection.checkAck(in);
            if (c != 67) {
                boolean bl = false;
                return bl;
            }
            in.read(buf, 0, 5);
            long fileSize = 0L;
            while (true) {
                if (in.read(buf, 0, 1) < 0) {
                    boolean bl = false;
                    return bl;
                }
                if (buf[0] == 32) break;
                fileSize = fileSize * 10L + (long)(buf[0] - 48);
            }
            String file = null;
            int i = 0;
            while (true) {
                in.read(buf, i, 1);
                if (buf[i] == 10) break;
                ++i;
            }
            file = new String(buf, 0, i);
            if (listener != null) {
                listener.onFileSizeCalculated(fileSize);
            }
            buf[0] = 0;
            out.write(buf, 0, 1);
            out.flush();
            fos = new FileOutputStream(prefix == null ? localFile : prefix + file);
            long progress = 0L;
            while (true) {
                int bytesToRead = (long)buf.length < fileSize ? buf.length : (int)fileSize;
                if ((bytesToRead = in.read(buf, 0, bytesToRead)) < 0) {
                    boolean bl = false;
                    return bl;
                }
                progress += (long)bytesToRead;
                fos.write(buf, 0, bytesToRead);
                if ((fileSize -= (long)bytesToRead) == 0L) break;
                if (listener == null) continue;
                listener.onDownloaded(localFile, progress);
            }
            fos.close();
            fos = null;
            if (SshConnection.checkAck(in) != 0) {
                boolean bl = false;
                return bl;
            }
            buf[0] = 0;
            out.write(buf, 0, 1);
            out.flush();
            session.disconnect();
        }
        catch (JSchException e) {
            throw new IOException(e);
        }
        finally {
            if (fos != null) {
                fos.close();
            }
            if (out != null) {
                out.close();
            }
            if (in != null) {
                in.close();
            }
            if (execChannel != null && execChannel.isConnected()) {
                execChannel.disconnect();
            }
            if (session != null && session.isConnected()) {
                session.disconnect();
            }
        }
        return true;
    }

    public boolean uploadFile(File localFile, String remoteFilePath, UploadListener listener) throws IOException {
        if (localFile == null || !localFile.isFile() || listener != null && !listener.shouldContinueUpload()) {
            return false;
        }
        Session session = null;
        Channel execChannel = null;
        FileInputStream fis = null;
        OutputStream out = null;
        InputStream in = null;
        try {
            boolean bl;
            int len;
            session = this.getSession();
            String command = "scp -t " + remoteFilePath;
            execChannel = session.openChannel(EXEC_CHANNEL_TYPE);
            ((ChannelExec)execChannel).setCommand(command);
            out = execChannel.getOutputStream();
            in = execChannel.getInputStream();
            execChannel.connect(15000);
            if (SshConnection.checkAck(in) != 0) {
                boolean bl2 = false;
                return bl2;
            }
            if (listener != null && !listener.shouldContinueUpload()) {
                boolean bl3 = false;
                return bl3;
            }
            long fileSize = localFile.length();
            command = "C0644 " + fileSize + " " + localFile.getName() + "\n";
            out.write(command.getBytes());
            out.flush();
            if (SshConnection.checkAck(in) != 0) {
                boolean bl4 = false;
                return bl4;
            }
            int bufferSize = 8192;
            fis = new FileInputStream(localFile);
            byte[] buffer = new byte[8192];
            long uploadedBytesCount = 0L;
            while ((len = fis.read(buffer, 0, 8192)) > 0) {
                out.write(buffer, 0, len);
                uploadedBytesCount += (long)len;
                if (listener == null) continue;
                listener.onUploaded(localFile, uploadedBytesCount, fileSize);
                if (listener.shouldContinueUpload()) continue;
                boolean bl5 = false;
                return bl5;
            }
            out.write(0);
            out.flush();
            if (SshConnection.checkAck(in) != 0) {
                bl = false;
                return bl;
            }
            bl = true;
            return bl;
        }
        catch (JSchException e) {
            throw new IOException(e);
        }
        finally {
            if (fis != null) {
                fis.close();
            }
            if (out != null) {
                out.close();
            }
            if (in != null) {
                in.close();
            }
            if (execChannel != null && execChannel.isConnected()) {
                execChannel.disconnect();
            }
            if (session != null && session.isConnected()) {
                session.disconnect();
            }
        }
    }

    private static int checkAck(InputStream in) throws IOException {
        int result = in.read();
        if (result == 1 || result == 2) {
            int character;
            StringBuilder errorMsg = new StringBuilder();
            do {
                character = in.read();
                errorMsg.append((char)character);
            } while (character != 10);
            if (errorMsg.length() > 0) {
                Timber.e((String)errorMsg.toString(), (Object[])new Object[0]);
            }
        }
        return result;
    }

    private static class SshSocketFactory
    implements com.jcraft.jsch.SocketFactory {
        private final SocketFactory socketFactory;

        private SshSocketFactory(SocketFactory socketFactory) {
            this.socketFactory = socketFactory;
        }

        public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
            return this.socketFactory.createSocket(host, port);
        }

        public InputStream getInputStream(Socket socket) throws IOException {
            return socket.getInputStream();
        }

        public OutputStream getOutputStream(Socket socket) throws IOException {
            return socket.getOutputStream();
        }
    }

    public static interface DownloadListener {
        public void onFileSizeCalculated(long var1);

        public void onDownloaded(String var1, long var2);
    }

    public static interface UploadListener {
        public void onUploaded(File var1, long var2, long var4);

        public boolean shouldContinueUpload();
    }
}

