/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.core.survey.grid;

import com.o3dr.services.android.lib.coordinate.LatLong;
import java.util.List;
import org.droidplanner.services.android.impl.core.helpers.geoTools.LineLatLong;
import org.droidplanner.services.android.impl.core.polygon.Polygon;
import org.droidplanner.services.android.impl.core.survey.SurveyData;
import org.droidplanner.services.android.impl.core.survey.grid.CircumscribedGrid;
import org.droidplanner.services.android.impl.core.survey.grid.EndpointSorter;
import org.droidplanner.services.android.impl.core.survey.grid.Grid;
import org.droidplanner.services.android.impl.core.survey.grid.Trimmer;

public class GridBuilder {
    private Polygon poly;
    private Double angle;
    private Double lineDist;
    private LatLong origin;
    private Double wpDistance;
    private Grid grid;

    public GridBuilder(Polygon polygon, SurveyData surveyData, LatLong originPoint) {
        this.poly = polygon;
        this.origin = originPoint;
        this.angle = surveyData.getAngle();
        this.lineDist = surveyData.getLateralPictureDistance();
        this.wpDistance = surveyData.getLongitudinalPictureDistance();
    }

    public GridBuilder(Polygon polygon, double angle, double distance, LatLong originPoint) {
        this.poly = polygon;
        this.origin = originPoint;
        this.angle = angle;
        this.lineDist = distance;
        this.wpDistance = distance;
    }

    public void setAngle(double newAngle) {
        this.angle = newAngle;
    }

    public Grid generate(boolean sort) throws Exception {
        List<LatLong> polygonPoints = this.poly.getPoints();
        List<LineLatLong> circumscribedGrid = new CircumscribedGrid(polygonPoints, this.angle, this.lineDist).getGrid();
        List<LineLatLong> trimedGrid = new Trimmer(circumscribedGrid, this.poly.getLines()).getTrimmedGrid();
        EndpointSorter gridSorter = new EndpointSorter(trimedGrid, this.wpDistance);
        gridSorter.sortGrid(this.origin, sort);
        this.grid = new Grid(gridSorter.getSortedGrid(), gridSorter.getCameraLocations());
        return this.grid;
    }
}

