/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.core.srtm;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.droidplanner.services.android.impl.core.srtm.Srtm;
import org.droidplanner.services.android.impl.core.srtm.SrtmRegions;
import org.droidplanner.services.android.impl.core.srtm.UnZip;

public class SrtmDownloader {
    static final String url = "http://dds.cr.usgs.gov/srtm/version2_1/SRTM3/";
    private Srtm.OnProgressListner listner;

    public SrtmDownloader(Srtm.OnProgressListner listner) {
        this.listner = listner;
    }

    public void downloadRegionIndex(int region, String srtmPath) throws IOException {
        String regionIndex = SrtmRegions.REGIONS[region] + ".index.html";
        regionIndex = SrtmDownloader.getIndexPath(srtmPath) + regionIndex;
        File regionIndexFile = new File(regionIndex);
        this.downloadFile(url + SrtmRegions.REGIONS[region] + "/", regionIndexFile);
    }

    public void downloadSrtmFile(String fname, String path) throws Exception {
        String region = new SrtmRegions(path).findRegion(fname, this.listner);
        File output = new File(path + "/" + fname + ".zip");
        this.downloadSrtmFile(fname, output, region);
        UnZip.unZipIt(fname, output);
        output.delete();
    }

    private void downloadSrtmFile(String fname, File output, String region) throws IOException {
        try {
            this.downloadFile(url + region + "/" + fname + ".zip", output);
        }
        catch (IOException e) {
            this.downloadAlternativeSrtmFile(fname, output, region, e);
        }
    }

    private void downloadAlternativeSrtmFile(String fname, File output, String region, IOException e) throws IOException {
        if (!fname.startsWith("N5") || !region.equalsIgnoreCase("North_America")) {
            throw e;
        }
        this.downloadFile(url + region + "/" + fname.replace(".hgt", "hgt") + ".zip", output);
    }

    private void downloadFile(String urlAddress, File file) throws IOException {
        int count;
        URL url = new URL(urlAddress);
        URLConnection connection = url.openConnection();
        connection.connect();
        long fileLength = connection.getContentLength();
        BufferedInputStream input = new BufferedInputStream(url.openStream());
        BufferedOutputStream outputs = new BufferedOutputStream(new FileOutputStream(file));
        byte[] data = new byte[2048];
        long total = 0L;
        while ((count = ((InputStream)input).read(data)) != -1) {
            outputs.write(data, 0, count);
            this.callListner(file.getName(), (int)((total += (long)count) * 100L / fileLength));
        }
        outputs.flush();
        outputs.close();
        ((InputStream)input).close();
    }

    private void callListner(String filename, int i) {
        if (this.listner != null) {
            if (i >= 0) {
                this.listner.onProgress(filename, i);
            } else {
                this.listner.onProgress(filename, -1);
            }
        }
    }

    public static String getIndexPath(String srtmPath) {
        return srtmPath + "/Index/";
    }
}

