/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.core.srtm;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.droidplanner.services.android.impl.core.srtm.Srtm;
import org.droidplanner.services.android.impl.core.srtm.SrtmDownloader;

public class SrtmData {
    private String path;
    private File srtmFile;
    private BufferedInputStream s;

    public SrtmData(String dir) {
        this.path = dir;
    }

    public int load(double lon, double lat, Srtm.OnProgressListner listner) throws Exception {
        String fname = SrtmData.getName(lon, lat);
        this.setupFilePaths(fname);
        this.downloadSrtmFileIfNeeded(fname, listner);
        this.s = new BufferedInputStream(new FileInputStream(this.srtmFile));
        int altitude = this.readHtgFile(this.s, lon, lat);
        this.s.close();
        return altitude;
    }

    private void downloadSrtmFileIfNeeded(String fname, Srtm.OnProgressListner listner) throws Exception {
        if (!this.srtmFile.exists()) {
            new SrtmDownloader(listner).downloadSrtmFile(fname, this.path);
        }
    }

    private void setupFilePaths(String fname) {
        this.srtmFile = new File(this.path + "/" + fname);
    }

    private int readHtgFile(BufferedInputStream s, double lon, double lat) throws Exception {
        byte[] buffer = new byte[2];
        int index = this.calculateFileIndex(lon, lat);
        this.skipToDataPositionInFile(index);
        s.read(buffer);
        return ByteBuffer.wrap(buffer).order(ByteOrder.BIG_ENDIAN).getShort();
    }

    private void skipToDataPositionInFile(int index) throws Exception {
        if (this.s.skip(index) != (long)index) {
            throw new Exception("error when skipping");
        }
    }

    private int calculateFileIndex(double lon, double lat) {
        int ai = (int)Math.round(1200.0 * (lat - Math.floor(lat)));
        int aj = (int)Math.round(1200.0 * (lon - Math.floor(lon)));
        int index = (aj + (1200 - ai) * 1201) * 2;
        return index;
    }

    static String getName(double Dlon, double Dlat) {
        int lon = (int)Math.floor(Dlon);
        int lat = (int)Math.floor(Dlat);
        String dirlat = "N";
        if (lat < 0) {
            dirlat = "S";
        }
        String dirlon = "E";
        if (lon < 0) {
            dirlon = "W";
        }
        String st = String.valueOf(Math.abs(lat));
        while (st.length() < 2) {
            st = "0" + st;
        }
        String fname = dirlat + st;
        st = String.valueOf(Math.abs(lon));
        while (st.length() < 3) {
            st = "0" + st;
        }
        fname = fname + dirlon + st + ".hgt";
        return fname;
    }
}

