/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.core.polygon;

import com.o3dr.services.android.lib.coordinate.LatLong;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.droidplanner.services.android.impl.core.helpers.geoTools.GeoTools;
import org.droidplanner.services.android.impl.core.helpers.geoTools.LineLatLong;
import org.droidplanner.services.android.impl.core.helpers.units.Area;

public class Polygon {
    private List<LatLong> points = new ArrayList<LatLong>();

    public void addPoints(List<LatLong> pointList) {
        for (LatLong point : pointList) {
            this.addPoint(point);
        }
    }

    public void addPoint(LatLong coord) {
        this.points.add(coord);
    }

    public void clearPolygon() {
        this.points.clear();
    }

    public List<LatLong> getPoints() {
        return this.points;
    }

    public List<LineLatLong> getLines() {
        ArrayList<LineLatLong> list = new ArrayList<LineLatLong>();
        for (int i = 0; i < this.points.size(); ++i) {
            int endIndex = i == 0 ? this.points.size() - 1 : i - 1;
            list.add(new LineLatLong(this.points.get(i), this.points.get(endIndex)));
        }
        return list;
    }

    public void movePoint(LatLong coord, int number) {
        this.points.get(number).set(coord);
    }

    public Area getArea() {
        return GeoTools.getArea(this);
    }

    public void checkIfValid() throws Exception {
        if (this.points.size() < 3) {
            throw new InvalidPolygon(this.points.size());
        }
    }

    public void reversePoints() {
        Collections.reverse(this.points);
    }

    public class InvalidPolygon
    extends Exception {
        private static final long serialVersionUID = 1L;
        public int size;

        public InvalidPolygon(int size) {
            this.size = size;
        }
    }
}

