/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.core.mission.survey;

import com.MAVLink.common.msg_mission_item;
import com.o3dr.services.android.lib.coordinate.LatLong;
import java.util.ArrayList;
import java.util.List;
import org.droidplanner.services.android.impl.core.mission.MissionImpl;
import org.droidplanner.services.android.impl.core.mission.MissionItemImpl;
import org.droidplanner.services.android.impl.core.mission.MissionItemType;
import org.droidplanner.services.android.impl.core.mission.commands.CameraTriggerImpl;
import org.droidplanner.services.android.impl.core.polygon.Polygon;
import org.droidplanner.services.android.impl.core.survey.CameraInfo;
import org.droidplanner.services.android.impl.core.survey.SurveyData;
import org.droidplanner.services.android.impl.core.survey.grid.Grid;
import org.droidplanner.services.android.impl.core.survey.grid.GridBuilder;

public class SurveyImpl
extends MissionItemImpl {
    public Polygon polygon = new Polygon();
    public SurveyData surveyData = new SurveyData();
    public Grid grid;
    private boolean startCameraBeforeFirstWaypoint;

    public SurveyImpl(MissionImpl missionImpl, List<LatLong> points) {
        super(missionImpl);
        this.polygon.addPoints(points);
    }

    public void update(double angle, double altitude, double overlap, double sidelap, boolean lockOrientation) {
        this.surveyData.update(angle, altitude, overlap, sidelap, lockOrientation);
    }

    public boolean isStartCameraBeforeFirstWaypoint() {
        return this.startCameraBeforeFirstWaypoint;
    }

    public void setStartCameraBeforeFirstWaypoint(boolean startCameraBeforeFirstWaypoint) {
        this.startCameraBeforeFirstWaypoint = startCameraBeforeFirstWaypoint;
    }

    public void setCameraInfo(CameraInfo camera) {
        this.surveyData.setCameraInfo(camera);
    }

    public void build() throws Exception {
        this.grid = null;
        GridBuilder gridBuilder = new GridBuilder(this.polygon, this.surveyData, new LatLong(0.0, 0.0));
        this.polygon.checkIfValid();
        this.grid = gridBuilder.generate(true);
    }

    @Override
    public List<msg_mission_item> packMissionItem() {
        try {
            ArrayList<msg_mission_item> list = new ArrayList<msg_mission_item>();
            this.build();
            this.packSurveyPoints(list);
            return list;
        }
        catch (Exception e) {
            return new ArrayList<msg_mission_item>();
        }
    }

    private void packSurveyPoints(List<msg_mission_item> list) {
        CameraTriggerImpl camTrigger = new CameraTriggerImpl(this.missionImpl, this.surveyData.getLongitudinalPictureDistance());
        if (this.startCameraBeforeFirstWaypoint) {
            list.addAll(camTrigger.packMissionItem());
        }
        double altitude = this.surveyData.getAltitude();
        boolean addToFirst = !this.startCameraBeforeFirstWaypoint;
        for (LatLong point : this.grid.gridPoints) {
            msg_mission_item mavMsg = this.getSurveyPoint(point, altitude);
            list.add(mavMsg);
            if (this.surveyData.getLockOrientation()) {
                msg_mission_item yawMsg = this.getYawCondition(this.surveyData.getAngle());
                list.add(yawMsg);
            }
            if (!addToFirst) continue;
            list.addAll(camTrigger.packMissionItem());
            addToFirst = false;
        }
        list.addAll(new CameraTriggerImpl(this.missionImpl, 0.0).packMissionItem());
    }

    protected msg_mission_item getSurveyPoint(LatLong point, double altitude) {
        return SurveyImpl.packSurveyPoint(point, altitude);
    }

    public static msg_mission_item packSurveyPoint(LatLong point, double altitude) {
        msg_mission_item mavMsg = new msg_mission_item();
        mavMsg.autocontinue = 1;
        mavMsg.frame = (short)3;
        mavMsg.command = 16;
        mavMsg.x = (float)point.getLatitude();
        mavMsg.y = (float)point.getLongitude();
        mavMsg.z = (float)altitude;
        mavMsg.param1 = 0.0f;
        mavMsg.param2 = 0.0f;
        mavMsg.param3 = 0.0f;
        mavMsg.param4 = 0.0f;
        return mavMsg;
    }

    private msg_mission_item getYawCondition(double angle) {
        msg_mission_item mavMsg = new msg_mission_item();
        mavMsg.autocontinue = 1;
        mavMsg.frame = (short)4;
        mavMsg.command = 115;
        mavMsg.x = 0.0f;
        mavMsg.y = 0.0f;
        mavMsg.z = 0.0f;
        mavMsg.param1 = (float)angle;
        mavMsg.param2 = 30.0f;
        mavMsg.param3 = 0.0f;
        mavMsg.param4 = 0.0f;
        return mavMsg;
    }

    @Override
    public void unpackMAVMessage(msg_mission_item mavMsg) {
    }

    @Override
    public MissionItemType getType() {
        return MissionItemType.SURVEY;
    }
}

