/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.core.helpers.geoTools.spline;

import com.o3dr.services.android.lib.coordinate.LatLong;
import java.util.ArrayList;
import java.util.List;

public class Spline {
    private static final double SPLINE_TENSION = 1.6;
    private LatLong p0;
    private LatLong p0_prime;
    private LatLong a;
    private LatLong b;

    public Spline(LatLong pMinus1, LatLong p0, LatLong p1, LatLong p2) {
        this.p0 = p0;
        this.p0_prime = p1.subtract(pMinus1).dot(0.625);
        LatLong p1_prime = p2.subtract(this.p0).dot(0.625);
        this.a = LatLong.sum(this.p0.dot(2.0), p1.dot(-2.0), this.p0_prime, p1_prime);
        this.b = LatLong.sum(this.p0.dot(-3.0), p1.dot(3.0), this.p0_prime.dot(-2.0), p1_prime.negate());
    }

    public List<LatLong> generateCoordinates(int decimation) {
        ArrayList<LatLong> result = new ArrayList<LatLong>();
        float step = 1.0f / (float)decimation;
        for (float i = 0.0f; i < 1.0f; i += step) {
            result.add(this.evaluate(i));
        }
        return result;
    }

    private LatLong evaluate(double t) {
        double tSquared = t * t;
        double tCubed = tSquared * t;
        return LatLong.sum(this.a.dot(tCubed), this.b.dot(tSquared), this.p0_prime.dot(t), this.p0);
    }
}

