/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.core.helpers.geoTools;

import com.o3dr.services.android.lib.coordinate.LatLong;
import com.o3dr.services.android.lib.coordinate.LatLongAlt;
import com.o3dr.services.android.lib.util.MathUtils;
import java.util.List;
import org.droidplanner.services.android.impl.core.helpers.units.Area;
import org.droidplanner.services.android.impl.core.polygon.Polygon;

public class GeoTools {
    private static final double RADIUS_OF_EARTH = 6378137.0;
    public List<LatLong> waypoints;

    public static Double getAproximatedDistance(LatLong p1, LatLong p2) {
        return Math.hypot(p1.getLatitude() - p2.getLatitude(), p1.getLongitude() - p2.getLongitude());
    }

    private static Double metersTolat(double meters) {
        return Math.toDegrees(meters / 6378137.0);
    }

    public static Double latToMeters(double lat) {
        return Math.toRadians(lat) * 6378137.0;
    }

    public static LatLong newCoordFromBearingAndDistance(LatLong origin, double bearing, double distance) {
        return GeoTools.newCoordFromBearingAndDistance(origin.getLatitude(), origin.getLongitude(), bearing, distance);
    }

    private static LatLong newCoordFromBearingAndDistance(double lat, double lon, double bearing, double distance) {
        double lat1 = Math.toRadians(lat);
        double lon1 = Math.toRadians(lon);
        double brng = Math.toRadians(bearing);
        double dr = distance / 6378137.0;
        double lat2 = Math.asin(Math.sin(lat1) * Math.cos(dr) + Math.cos(lat1) * Math.sin(dr) * Math.cos(brng));
        double lon2 = lon1 + Math.atan2(Math.sin(brng) * Math.sin(dr) * Math.cos(lat1), Math.cos(dr) - Math.sin(lat1) * Math.sin(lat2));
        return new LatLong(Math.toDegrees(lat2), Math.toDegrees(lon2));
    }

    public static LatLong moveCoordinate(LatLong origin, double xMeters, double yMeters) {
        double lon = origin.getLongitude();
        double lat = origin.getLatitude();
        double lon1 = Math.toRadians(lon);
        double lat1 = Math.toRadians(lat);
        double lon2 = lon1 + Math.toRadians(GeoTools.metersTolat(xMeters));
        double lat2 = lat1 + Math.toRadians(GeoTools.metersTolat(yMeters));
        return new LatLong(Math.toDegrees(lat2), Math.toDegrees(lon2));
    }

    static double getArcInRadians(LatLong from, LatLong to) {
        double latitudeArc = Math.toRadians(from.getLatitude() - to.getLatitude());
        double longitudeArc = Math.toRadians(from.getLongitude() - to.getLongitude());
        double latitudeH = Math.sin(latitudeArc * 0.5);
        latitudeH *= latitudeH;
        double lontitudeH = Math.sin(longitudeArc * 0.5);
        lontitudeH *= lontitudeH;
        double tmp = Math.cos(Math.toRadians(from.getLatitude())) * Math.cos(Math.toRadians(to.getLatitude()));
        return Math.toDegrees(2.0 * Math.asin(Math.sqrt(latitudeH + tmp * lontitudeH)));
    }

    public static double getDistance(LatLong from, LatLong to) {
        return 6378137.0 * Math.toRadians(GeoTools.getArcInRadians(from, to));
    }

    public static double get3DDistance(LatLongAlt end, LatLongAlt start) {
        double horizontalDistance = GeoTools.getDistance(end, start);
        double altitudeDiff = Math.abs(end.getAltitude() - start.getAltitude());
        return MathUtils.hypot(horizontalDistance, altitudeDiff);
    }

    public static double getHeadingFromCoordinates(LatLong fromLoc, LatLong toLoc) {
        double fLat = Math.toRadians(fromLoc.getLatitude());
        double fLng = Math.toRadians(fromLoc.getLongitude());
        double tLat = Math.toRadians(toLoc.getLatitude());
        double tLng = Math.toRadians(toLoc.getLongitude());
        double degree = Math.toDegrees(Math.atan2(Math.sin(tLng - fLng) * Math.cos(tLat), Math.cos(fLat) * Math.sin(tLat) - Math.sin(fLat) * Math.cos(tLat) * Math.cos(tLng - fLng)));
        return GeoTools.warpToPositiveAngle(degree);
    }

    public static double warpToPositiveAngle(double degree) {
        if (degree >= 0.0) {
            return degree;
        }
        return 360.0 + degree;
    }

    public static Area getArea(Polygon poly) {
        List<LatLong> path = poly.getPoints();
        int size = path.size();
        if (size < 3) {
            return new Area(0.0);
        }
        double total = 0.0;
        LatLong prev = path.get(size - 1);
        double prevTanLat = Math.tan((1.5707963267948966 - Math.toRadians(prev.getLatitude())) / 2.0);
        double prevLng = Math.toRadians(prev.getLongitude());
        for (LatLong point : path) {
            double tanLat = Math.tan((1.5707963267948966 - Math.toRadians(point.getLatitude())) / 2.0);
            double lng = Math.toRadians(point.getLongitude());
            total += GeoTools.polarTriangleArea(tanLat, lng, prevTanLat, prevLng);
            prevTanLat = tanLat;
            prevLng = lng;
        }
        return new Area(Math.abs(total * 4.0680631590769E13));
    }

    private static double polarTriangleArea(double tan1, double lng1, double tan2, double lng2) {
        double deltaLng = lng1 - lng2;
        double t = tan1 * tan2;
        return 2.0 * Math.atan2(t * Math.sin(deltaLng), 1.0 + t * Math.cos(deltaLng));
    }

    public static LatLong pointAlongTheLine(LatLong start, LatLong end, int distance) {
        return GeoTools.newCoordFromBearingAndDistance(start, GeoTools.getHeadingFromCoordinates(start, end), distance);
    }
}

