/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.core.gcs.follow;

import android.os.Handler;
import com.o3dr.services.android.lib.coordinate.LatLong;
import com.o3dr.services.android.lib.coordinate.LatLongAlt;
import com.o3dr.services.android.lib.drone.property.Gps;
import org.droidplanner.services.android.impl.core.drone.manager.MavLinkDroneManager;
import org.droidplanner.services.android.impl.core.gcs.follow.FollowAlgorithm;
import org.droidplanner.services.android.impl.core.gcs.follow.FollowWithRadiusAlgorithm;
import org.droidplanner.services.android.impl.core.gcs.location.Location;
import org.droidplanner.services.android.impl.core.helpers.geoTools.GeoTools;

public class FollowSplineLeash
extends FollowWithRadiusAlgorithm {
    @Override
    public void processNewLocation(Location location) {
        LatLongAlt userLoc = location.getCoord();
        Gps droneGps = (Gps)this.drone.getAttribute("com.o3dr.services.android.lib.attribute.GPS");
        LatLong droneLoc = droneGps.getPosition();
        if (userLoc == null || droneLoc == null) {
            return;
        }
        if (GeoTools.getDistance(userLoc, droneLoc) > this.radius) {
            double headingGCSToDrone = GeoTools.getHeadingFromCoordinates(userLoc, droneLoc);
            LatLong goCoord = GeoTools.newCoordFromBearingAndDistance(userLoc, headingGCSToDrone, this.radius);
            double speed = location.getSpeed();
            double bearing = location.getBearing();
            double bearingInRad = Math.toRadians(bearing);
            double xVel = speed * Math.cos(bearingInRad);
            double yVel = speed * Math.sin(bearingInRad);
            this.drone.getGuidedPoint().newGuidedCoordAndVelocity(goCoord, xVel, yVel, 0.0);
        }
    }

    @Override
    public FollowAlgorithm.FollowModes getType() {
        return FollowAlgorithm.FollowModes.SPLINE_LEASH;
    }

    public FollowSplineLeash(MavLinkDroneManager droneMgr, Handler handler, double length) {
        super(droneMgr, handler, length);
    }
}

