/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.core.gcs.follow;

import android.os.Handler;
import com.o3dr.services.android.lib.coordinate.LatLong;
import com.o3dr.services.android.lib.coordinate.LatLongAlt;
import com.o3dr.services.android.lib.drone.companion.solo.tlv.SoloMessageLocation;
import org.droidplanner.services.android.impl.core.drone.autopilot.MavLinkDrone;
import org.droidplanner.services.android.impl.core.drone.autopilot.apm.solo.ArduSolo;
import org.droidplanner.services.android.impl.core.drone.autopilot.apm.solo.SoloComp;
import org.droidplanner.services.android.impl.core.drone.manager.MavLinkDroneManager;
import org.droidplanner.services.android.impl.core.gcs.follow.FollowAlgorithm;
import org.droidplanner.services.android.impl.core.gcs.location.Location;
import org.droidplanner.services.android.impl.core.gcs.roi.ROIEstimator;

public class FollowSoloShot
extends FollowAlgorithm {
    private final SoloComp soloComp;
    private final LatLongAlt locationCoord = new LatLongAlt(0.0, 0.0, 0.0);
    private final SoloMessageLocation locationSetter = new SoloMessageLocation(this.locationCoord);

    public FollowSoloShot(MavLinkDroneManager droneMgr, Handler handler) {
        super(droneMgr, handler);
        ArduSolo drone = (ArduSolo)droneMgr.getDrone();
        this.soloComp = drone.getSoloComp();
    }

    @Override
    public void enableFollow() {
        super.enableFollow();
        this.soloComp.enableFollowDataConnection();
    }

    @Override
    public void disableFollow() {
        super.disableFollow();
        this.soloComp.disableFollowDataConnection();
    }

    @Override
    protected void processNewLocation(Location location) {
        if (location != null) {
            LatLongAlt receivedCoord = location.getCoord();
            this.locationCoord.set((LatLong)receivedCoord);
            this.locationSetter.setCoordinate(this.locationCoord);
            this.soloComp.updateFollowCenter(this.locationSetter);
        }
    }

    @Override
    public FollowAlgorithm.FollowModes getType() {
        return FollowAlgorithm.FollowModes.SOLO_SHOT;
    }

    @Override
    protected ROIEstimator initROIEstimator(MavLinkDrone drone, Handler handler) {
        return new SoloROIEstimator(drone, handler, ((ArduSolo)drone).getSoloComp());
    }

    protected static class SoloROIEstimator
    extends ROIEstimator {
        private final LatLongAlt locationCoord = new LatLongAlt(0.0, 0.0, 0.0);
        private final SoloMessageLocation locationSetter = new SoloMessageLocation(this.locationCoord);
        private final SoloComp soloComp;

        public SoloROIEstimator(MavLinkDrone drone, Handler handler, SoloComp soloComp) {
            super(drone, handler);
            this.soloComp = soloComp;
        }

        @Override
        public void enableFollow() {
            this.isFollowEnabled.set(true);
        }

        @Override
        public void disableFollow() {
            if (this.isFollowEnabled.compareAndSet(true, false)) {
                this.realLocation = null;
                this.disableWatchdog();
            }
        }

        @Override
        protected long getUpdatePeriod() {
            return 40L;
        }

        @Override
        protected void sendUpdateROI(LatLong goCoord) {
            this.locationCoord.set(goCoord);
            this.locationSetter.setCoordinate(this.locationCoord);
            this.soloComp.updateFollowCenter(this.locationSetter);
        }
    }
}

