/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.core.gcs.follow;

import android.os.Handler;
import com.o3dr.services.android.lib.coordinate.LatLong;
import com.o3dr.services.android.lib.coordinate.LatLongAlt;
import com.o3dr.services.android.lib.drone.property.Gps;
import org.droidplanner.services.android.impl.core.drone.manager.MavLinkDroneManager;
import org.droidplanner.services.android.impl.core.gcs.follow.FollowAlgorithm;
import org.droidplanner.services.android.impl.core.gcs.follow.FollowWithRadiusAlgorithm;
import org.droidplanner.services.android.impl.core.gcs.location.Location;
import org.droidplanner.services.android.impl.core.helpers.geoTools.GeoTools;

public class FollowLeash
extends FollowWithRadiusAlgorithm {
    public FollowLeash(MavLinkDroneManager droneMgr, Handler handler, double radius) {
        super(droneMgr, handler, radius);
    }

    @Override
    public FollowAlgorithm.FollowModes getType() {
        return FollowAlgorithm.FollowModes.LEASH;
    }

    @Override
    protected void processNewLocation(Location location) {
        LatLongAlt locationCoord = location.getCoord();
        Gps droneGps = (Gps)this.drone.getAttribute("com.o3dr.services.android.lib.attribute.GPS");
        LatLong dronePosition = droneGps.getPosition();
        if (locationCoord == null || dronePosition == null) {
            return;
        }
        if (GeoTools.getDistance(locationCoord, dronePosition) > this.radius) {
            double headingGCStoDrone = GeoTools.getHeadingFromCoordinates(locationCoord, dronePosition);
            LatLong goCoord = GeoTools.newCoordFromBearingAndDistance(locationCoord, headingGCStoDrone, this.radius);
            this.drone.getGuidedPoint().newGuidedCoord(goCoord);
        }
    }
}

