/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.core.drone.autopilot.apm.variables;

import android.os.Handler;
import org.droidplanner.services.android.impl.core.drone.DroneInterfaces;
import org.droidplanner.services.android.impl.core.drone.autopilot.MavLinkDrone;
import org.droidplanner.services.android.impl.core.drone.autopilot.apm.ArduPilot;
import org.droidplanner.services.android.impl.core.drone.variables.HeartBeat;

public class APMHeartBeat
extends HeartBeat {
    private static final long HEARTBEAT_IMU_CALIBRATION_TIMEOUT = 35000L;
    protected static final int IMU_CALIBRATION = 3;

    public APMHeartBeat(ArduPilot myDrone, Handler handler) {
        super(myDrone, handler);
    }

    @Override
    public void onDroneEvent(DroneInterfaces.DroneEventsType event, MavLinkDrone drone) {
        switch (event) {
            case CALIBRATION_IMU: {
                this.heartbeatState = 3;
                this.restartWatchdog(35000L);
                break;
            }
            default: {
                super.onDroneEvent(event, drone);
            }
        }
    }

    @Override
    protected void onHeartbeatTimeout() {
        switch (this.heartbeatState) {
            case 3: {
                this.restartWatchdog(35000L);
                this.myDrone.notifyDroneEvent(DroneInterfaces.DroneEventsType.CALIBRATION_TIMEOUT);
                break;
            }
            default: {
                super.onHeartbeatTimeout();
            }
        }
    }
}

