/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.core.drone.autopilot.apm.solo.controller;

import android.content.Context;
import android.os.Handler;
import android.text.TextUtils;
import android.util.Pair;
import com.github.zafarkhaja.semver.Version;
import com.o3dr.android.client.utils.TxPowerComplianceCountries;
import com.o3dr.android.client.utils.connection.IpConnectionListener;
import com.o3dr.android.client.utils.connection.TcpConnection;
import com.o3dr.services.android.lib.drone.companion.solo.button.ButtonPacket;
import com.o3dr.services.android.lib.drone.companion.solo.tlv.TLVMessageParser;
import com.o3dr.services.android.lib.drone.companion.solo.tlv.TLVPacket;
import com.o3dr.services.android.lib.model.ICommandListener;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.droidplanner.services.android.impl.communication.model.DataLink;
import org.droidplanner.services.android.impl.core.drone.autopilot.apm.solo.AbstractLinkManager;
import org.droidplanner.services.android.impl.core.drone.autopilot.apm.solo.controller.ControllerLinkListener;
import org.droidplanner.services.android.impl.utils.NetworkUtils;
import org.droidplanner.services.android.impl.utils.connection.SshConnection;
import timber.log.Timber;

public class ControllerLinkManager
extends AbstractLinkManager<ControllerLinkListener> {
    private static final Version CONTROLLER_MODE_MIN_VERSION = Version.forIntegers((int)1, (int)1, (int)13);
    public static final String SOLOLINK_SSID_CONFIG_PATH = "/usr/bin/sololink_config";
    private static final String ARTOO_VERSION_FILENAME = "/VERSION";
    private static final String STM32_VERSION_FILENAME = "/STM_VERSION";
    public static final String ARTOO_IP = "10.1.1.1";
    private static final int ARTOO_VIDEO_HANDSHAKE_PORT = 5502;
    private static final int ARTOO_BUTTON_PORT = 5016;
    private static final int ARTOO_BATTERY_PORT = 5021;
    public static final int ARTOO_UDP_PORT = 5600;
    private final AtomicReference<String> controllerVersion = new AtomicReference<String>("");
    private final AtomicReference<String> stm32Version = new AtomicReference<String>("");
    private final AtomicReference<String> txPowerCompliantCountry = new AtomicReference<String>(TxPowerComplianceCountries.getDefaultCountry().name());
    private final AtomicInteger controllerMode = new AtomicInteger(0);
    private final AtomicReference<String> controllerUnits = new AtomicReference<String>("");
    private final AtomicReference<Pair<String, String>> sololinkWifiInfo = new AtomicReference<Pair>(Pair.create((Object)"", (Object)""));
    private final Runnable reconnectBatteryTask = new Runnable(){

        @Override
        public void run() {
            ControllerLinkManager.this.handler.removeCallbacks((Runnable)this);
            ControllerLinkManager.this.batteryConnection.connect(ControllerLinkManager.this.linkProvider.getConnectionExtras());
        }
    };
    private final Runnable reconnectVideoHandshake = new Runnable(){

        @Override
        public void run() {
            ControllerLinkManager.this.handler.removeCallbacks((Runnable)this);
            ControllerLinkManager.this.videoHandshake.connect(ControllerLinkManager.this.linkProvider.getConnectionExtras());
        }
    };
    private final AtomicBoolean isVideoHandshakeStarted = new AtomicBoolean(false);
    private final AtomicBoolean isBatteryStarted = new AtomicBoolean(false);
    private final TcpConnection videoHandshake;
    private final TcpConnection batteryConnection;
    protected final SshConnection sshLink;
    private final Runnable artooVersionRetriever = new Runnable(){

        @Override
        public void run() {
            String version = ControllerLinkManager.this.retrieveVersion(ControllerLinkManager.ARTOO_VERSION_FILENAME);
            if (version != null) {
                ControllerLinkManager.this.controllerVersion.set(version);
            }
            ControllerLinkManager.this.updateControllerModeIfPossible();
            ControllerLinkManager.this.updateControllerUnitIfPossible();
            ControllerLinkManager.this.onVersionsUpdated();
        }
    };
    private final Runnable stm32VersionRetriever = new Runnable(){

        @Override
        public void run() {
            String version = ControllerLinkManager.this.retrieveVersion(ControllerLinkManager.STM32_VERSION_FILENAME);
            if (version != null) {
                ControllerLinkManager.this.stm32Version.set(version);
            }
            ControllerLinkManager.this.onVersionsUpdated();
        }
    };
    private final Runnable loadWifiInfo = new Runnable(){

        @Override
        public void run() {
            try {
                String wifiName = ControllerLinkManager.this.sshLink.execute("/usr/bin/sololink_config --get-wifi-ssid");
                String wifiPassword = ControllerLinkManager.this.sshLink.execute("/usr/bin/sololink_config --get-wifi-password");
                if (!TextUtils.isEmpty((CharSequence)wifiName) && !TextUtils.isEmpty((CharSequence)wifiPassword)) {
                    Pair wifiInfo = Pair.create((Object)wifiName.trim(), (Object)wifiPassword.trim());
                    ControllerLinkManager.this.sololinkWifiInfo.set(wifiInfo);
                    if (ControllerLinkManager.this.linkListener != null) {
                        ControllerLinkManager.this.linkListener.onWifiInfoUpdated((String)wifiInfo.first, (String)wifiInfo.second);
                    }
                }
            }
            catch (IOException e) {
                Timber.e((Throwable)e, (String)"Unable to retrieve sololink wifi info.", (Object[])new Object[0]);
            }
        }
    };
    private final Runnable checkEUTxPowerCompliance = new Runnable(){

        @Override
        public void run() {
            String compliantCountry;
            try {
                compliantCountry = ControllerLinkManager.this.sshLink.execute("/usr/bin/sololink_config --get-wifi-country").trim();
                if (ControllerLinkManager.this.linkListener != null) {
                    ControllerLinkManager.this.linkListener.onTxPowerComplianceCountryUpdated(compliantCountry);
                }
            }
            catch (IOException e) {
                Timber.e((Throwable)e, (String)"Error occurred while querying wifi country.", (Object[])new Object[0]);
                compliantCountry = TxPowerComplianceCountries.getDefaultCountry().name();
            }
            ControllerLinkManager.this.txPowerCompliantCountry.set(compliantCountry);
        }
    };
    private final Runnable artooModeRetriever = new Runnable(){

        @Override
        public void run() {
            Timber.i((String)"Retrieving controller mode", (Object[])new Object[0]);
            try {
                String trimmedResponse;
                String response = ControllerLinkManager.this.sshLink.execute("/usr/bin/sololink_config --get-ui-mode");
                switch (trimmedResponse = TextUtils.isEmpty((CharSequence)response) ? "" : response.trim()) {
                    case "1": {
                        ControllerLinkManager.this.setControllerMode(1);
                        break;
                    }
                    case "2": {
                        ControllerLinkManager.this.setControllerMode(2);
                        break;
                    }
                    default: {
                        Timber.w((String)"Unable to parse received controller mode.", (Object[])new Object[0]);
                        ControllerLinkManager.this.setControllerMode(0);
                        break;
                    }
                }
            }
            catch (IOException e) {
                Timber.e((Throwable)e, (String)"Error occurred while getting controller mode.", (Object[])new Object[0]);
            }
        }
    };
    private final Runnable unitsRetriever = new Runnable(){

        @Override
        public void run() {
            Timber.d((String)"Retrieving controller units.", (Object[])new Object[0]);
            try {
                String trimmedResponse;
                String response = ControllerLinkManager.this.sshLink.execute("/usr/bin/sololink_config --get-ui-units");
                switch (trimmedResponse = TextUtils.isEmpty((CharSequence)response) ? "unknown" : response.trim()) {
                    case "metric": 
                    case "imperial": 
                    case "unknown": {
                        ControllerLinkManager.this.setControllerUnit(trimmedResponse);
                        break;
                    }
                    default: {
                        Timber.w((String)"Received unknown value for controller unit: %s", (Object[])new Object[]{trimmedResponse});
                        break;
                    }
                }
            }
            catch (IOException e) {
                Timber.e((Throwable)e, (String)"Error occurred while retrieving the controller units.", (Object[])new Object[0]);
            }
        }
    };
    private ControllerLinkListener linkListener;
    private final AtomicBoolean streamingPermission = new AtomicBoolean(false);

    public ControllerLinkManager(Context context, final Handler handler, ExecutorService asyncExecutor, DataLink.DataLinkProvider linkProvider) {
        super(context, new TcpConnection(handler, ARTOO_IP, 5016), handler, asyncExecutor, linkProvider);
        this.sshLink = new SshConnection(ARTOO_IP, "root", "TjSDBkAu", linkProvider);
        this.videoHandshake = new TcpConnection(handler, ARTOO_IP, 5502);
        this.videoHandshake.setIpConnectionListener(new IpConnectionListener(){

            @Override
            public void onIpConnected() {
                handler.removeCallbacks(ControllerLinkManager.this.reconnectVideoHandshake);
                Timber.d((String)"Artoo link connected. Starting video stream...", (Object[])new Object[0]);
                ControllerLinkManager.this.streamingPermission.set(true);
            }

            @Override
            public void onIpDisconnected() {
                ControllerLinkManager.this.streamingPermission.set(false);
                if (ControllerLinkManager.this.isVideoHandshakeStarted.get()) {
                    handler.postDelayed(ControllerLinkManager.this.reconnectVideoHandshake, 1000L);
                }
            }

            @Override
            public void onPacketReceived(ByteBuffer packetBuffer) {
            }
        });
        this.batteryConnection = new TcpConnection(handler, ARTOO_IP, 5021);
        this.batteryConnection.setIpConnectionListener(new IpConnectionListener(){

            @Override
            public void onIpConnected() {
                handler.removeCallbacks(ControllerLinkManager.this.reconnectBatteryTask);
            }

            @Override
            public void onIpDisconnected() {
                if (ControllerLinkManager.this.isBatteryStarted.get()) {
                    handler.postDelayed(ControllerLinkManager.this.reconnectBatteryTask, 1000L);
                }
            }

            @Override
            public void onPacketReceived(ByteBuffer packetBuffer) {
                List<TLVPacket> tlvMsgs = TLVMessageParser.parseTLVPacket(packetBuffer);
                if (tlvMsgs.isEmpty()) {
                    return;
                }
                for (TLVPacket tlvMsg : tlvMsgs) {
                    int messageType = tlvMsg.getMessageType();
                    Timber.d((String)("Received tlv message: " + messageType), (Object[])new Object[0]);
                    if (ControllerLinkManager.this.linkListener == null) continue;
                    ControllerLinkManager.this.linkListener.onTlvPacketReceived(tlvMsg);
                }
            }
        });
    }

    public boolean hasStreamingPermission() {
        return this.streamingPermission.get();
    }

    public boolean areVersionsSet() {
        return !TextUtils.isEmpty((CharSequence)this.controllerVersion.get()) && !TextUtils.isEmpty((CharSequence)this.stm32Version.get());
    }

    public String getArtooVersion() {
        return this.controllerVersion.get();
    }

    public String getStm32Version() {
        return this.stm32Version.get();
    }

    public String getTxPowerCompliantCountry() {
        return this.txPowerCompliantCountry.get();
    }

    public int getControllerMode() {
        int mode = this.controllerMode.get();
        return mode;
    }

    public String getControllerUnit() {
        String unit = this.controllerUnits.get();
        return unit;
    }

    private void startVideoManager() {
        this.handler.removeCallbacks(this.reconnectVideoHandshake);
        this.isVideoHandshakeStarted.set(true);
        this.videoHandshake.connect(this.linkProvider.getConnectionExtras());
    }

    private void stopVideoManager() {
        this.handler.removeCallbacks(this.reconnectVideoHandshake);
        this.isVideoHandshakeStarted.set(false);
        this.videoHandshake.disconnect();
    }

    private void loadSololinkWifiInfo() {
        this.postAsyncTask(this.loadWifiInfo);
    }

    public boolean updateSololinkWifi(CharSequence wifiSsid, CharSequence password) {
        Timber.d((String)String.format(Locale.US, "Updating artoo wifi ssid to %s with password %s", wifiSsid, password), (Object[])new Object[0]);
        try {
            String ssidUpdateResult = this.sshLink.execute("/usr/bin/sololink_config --set-wifi-ssid " + wifiSsid);
            String passwordUpdateResult = this.sshLink.execute("/usr/bin/sololink_config --set-wifi-password " + password);
            this.restartController();
            return true;
        }
        catch (IOException e) {
            Timber.e((Throwable)e, (String)"Error occurred while updating the sololink wifi ssid.", (Object[])new Object[0]);
            return false;
        }
    }

    public Pair<String, String> getSoloLinkWifiInfo() {
        return this.sololinkWifiInfo.get();
    }

    @Override
    public void start(ControllerLinkListener listener) {
        this.linkListener = listener;
        if (!this.isStarted()) {
            Timber.i((String)"Starting artoo link manager", (Object[])new Object[0]);
        }
        super.start(listener);
    }

    @Override
    public void stop() {
        if (this.isStarted()) {
            Timber.i((String)"Stopping artoo link manager", (Object[])new Object[0]);
        }
        super.stop();
    }

    @Override
    public boolean isLinkConnected() {
        return NetworkUtils.isOnSololinkNetwork(this.context);
    }

    @Override
    public void refreshState() {
        Timber.d((String)"Artoo link connected.", (Object[])new Object[0]);
        this.loadMacAddress();
        this.startVideoManager();
        this.loadSololinkWifiInfo();
        this.refreshControllerVersions();
        this.loadCurrentEUTxPowerComplianceMode();
    }

    @Override
    protected SshConnection getSshLink() {
        return this.sshLink;
    }

    private void onVersionsUpdated() {
        if (this.linkListener != null && this.areVersionsSet()) {
            this.linkListener.onVersionsUpdated();
        }
    }

    private void updateControllerUnitIfPossible() {
        if (this.doesSupportControllerMode()) {
            Timber.d((String)"Updating current controller unit.", (Object[])new Object[0]);
            this.loadControllerUnit();
        } else {
            Timber.w((String)"This controller version doesn't support controller unit retrieval.", (Object[])new Object[0]);
        }
    }

    private void updateControllerModeIfPossible() {
        if (this.doesSupportControllerMode()) {
            Timber.d((String)"Updating current controller mode.", (Object[])new Object[0]);
            this.loadCurrentControllerMode();
        } else {
            Timber.w((String)"This controller version doesn't support controller mode retrieval.", (Object[])new Object[0]);
        }
    }

    private boolean doesSupportControllerMode() {
        String version = this.controllerVersion.get();
        if (TextUtils.isEmpty((CharSequence)version)) {
            return false;
        }
        try {
            Version currentVersion = Version.valueOf((String)version);
            return CONTROLLER_MODE_MIN_VERSION.lessThanOrEqualTo(currentVersion);
        }
        catch (Exception e) {
            Timber.e((Throwable)e, (String)"Unable to parse controller version.", (Object[])new Object[0]);
            return false;
        }
    }

    @Override
    public void onIpDisconnected() {
        Timber.d((String)"Artoo link disconnected.", (Object[])new Object[0]);
        this.stopVideoManager();
        super.onIpDisconnected();
    }

    @Override
    public void onPacketReceived(ByteBuffer packetBuffer) {
        ButtonPacket buttonPacket = ButtonPacket.parseButtonPacket(packetBuffer);
        if (buttonPacket == null) {
            return;
        }
        byte buttonId = buttonPacket.getButtonId();
        Timber.d((String)("Button pressed: " + buttonId), (Object[])new Object[0]);
        if (this.linkListener != null) {
            this.linkListener.onButtonPacketReceived(buttonPacket);
        }
    }

    private void updateArtooVersion() {
        this.postAsyncTask(this.artooVersionRetriever);
    }

    private void updateStm32Version() {
        this.postAsyncTask(this.stm32VersionRetriever);
    }

    private String retrieveVersion(String versionFile) {
        try {
            String version = this.sshLink.execute("cat " + versionFile);
            if (TextUtils.isEmpty((CharSequence)version)) {
                Timber.d((String)"No version file was found", (Object[])new Object[0]);
                return "";
            }
            return version.split("\n")[0];
        }
        catch (IOException e) {
            Timber.e((String)"Unable to retrieve the current version.", (Object[])new Object[]{e});
            return null;
        }
    }

    public void updateControllerUnit(final String unit, final ICommandListener listener) {
        this.postAsyncTask(new Runnable(){

            @Override
            public void run() {
                boolean supportControllerMode = ControllerLinkManager.this.doesSupportControllerMode();
                if (!supportControllerMode) {
                    ControllerLinkManager.this.postErrorEvent(3, listener);
                    return;
                }
                Timber.d((String)"Switching controller unit to %s", (Object[])new Object[]{unit});
                try {
                    String command = "/usr/bin/sololink_config --set-ui-units %s";
                    String response = ControllerLinkManager.this.sshLink.execute(String.format(Locale.US, "/usr/bin/sololink_config --set-ui-units %s", unit));
                    Timber.d((String)"Response from unit change was: %s", (Object[])new Object[]{response});
                    ControllerLinkManager.this.postSuccessEvent(listener);
                    ControllerLinkManager.this.setControllerUnit(unit);
                }
                catch (IOException e) {
                    Timber.e((Throwable)e, (String)"Error occurred while changing controller unit.", (Object[])new Object[0]);
                    ControllerLinkManager.this.postTimeoutEvent(listener);
                }
            }
        });
    }

    private void setControllerUnit(String unit) {
        this.controllerUnits.set(unit);
        if (this.linkListener != null) {
            this.linkListener.onControllerUnitUpdated(unit);
        }
    }

    public void updateControllerMode(final int mode, final ICommandListener listener) {
        this.postAsyncTask(new Runnable(){

            @Override
            public void run() {
                Timber.d((String)"Switching controller to mode %d", (Object[])new Object[]{mode});
                try {
                    String response;
                    boolean supportControllerMode = ControllerLinkManager.this.doesSupportControllerMode();
                    String command = supportControllerMode ? "/usr/bin/sololink_config --set-ui-mode %d" : "runStickMapperMode%d.sh";
                    switch (mode) {
                        case 1: {
                            response = ControllerLinkManager.this.sshLink.execute(String.format(Locale.US, command, mode));
                            ControllerLinkManager.this.postSuccessEvent(listener);
                            break;
                        }
                        case 2: {
                            response = ControllerLinkManager.this.sshLink.execute(String.format(Locale.US, command, mode));
                            ControllerLinkManager.this.postSuccessEvent(listener);
                            break;
                        }
                        default: {
                            response = "No response.";
                            ControllerLinkManager.this.postErrorEvent(3, listener);
                        }
                    }
                    Timber.d((String)"Response from switch mode command was: %s", (Object[])new Object[]{response});
                    if (supportControllerMode) {
                        ControllerLinkManager.this.setControllerMode(mode);
                    }
                }
                catch (IOException e) {
                    Timber.e((Throwable)e, (String)"Error occurred while changing controller modes.", (Object[])new Object[0]);
                    ControllerLinkManager.this.postTimeoutEvent(listener);
                }
            }
        });
    }

    private void setControllerMode(int mode) {
        this.controllerMode.set(mode);
        if (this.linkListener != null) {
            this.linkListener.onControllerModeUpdated();
        }
    }

    public void setTxPowerComplianceCountry(final String compliantCountry, final ICommandListener listener) {
        this.postAsyncTask(new Runnable(){

            @Override
            public void run() {
                Timber.d((String)"Enabling %s Tx power compliance mode", (Object[])new Object[]{compliantCountry});
                try {
                    String currentCompliance = ControllerLinkManager.this.sshLink.execute("/usr/bin/sololink_config --get-wifi-country").trim();
                    if (!currentCompliance.equals(compliantCountry)) {
                        String response = ControllerLinkManager.this.sshLink.execute("/usr/bin/sololink_config --set-wifi-country " + compliantCountry + "; echo $?");
                        if (response.trim().equals("0")) {
                            ControllerLinkManager.this.restartController();
                            Timber.d((String)"wifi country successfully set, rebooting artoo", (Object[])new Object[0]);
                            ControllerLinkManager.this.txPowerCompliantCountry.set(compliantCountry);
                            ControllerLinkManager.this.postSuccessEvent(listener);
                        } else {
                            Timber.d((String)"wifi country set failed: %s", (Object[])new Object[]{response});
                            ControllerLinkManager.this.postErrorEvent(4, listener);
                        }
                    }
                }
                catch (IOException e) {
                    Timber.e((Throwable)e, (String)"Error occurred while changing wifi country.", (Object[])new Object[0]);
                    ControllerLinkManager.this.postTimeoutEvent(listener);
                }
            }
        });
    }

    private void loadCurrentEUTxPowerComplianceMode() {
        this.postAsyncTask(this.checkEUTxPowerCompliance);
    }

    private void loadCurrentControllerMode() {
        this.postAsyncTask(this.artooModeRetriever);
    }

    private void loadControllerUnit() {
        this.postAsyncTask(this.unitsRetriever);
    }

    private void restartController() {
        try {
            this.sshLink.execute("/usr/bin/sololink_config --reboot");
        }
        catch (IOException e) {
            Timber.e((Throwable)e, (String)"Error occurred while restarting hostpad service on Artoo.", (Object[])new Object[0]);
        }
    }

    public void refreshControllerVersions() {
        this.updateArtooVersion();
        this.updateStm32Version();
    }
}

