/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.core.drone.autopilot.apm.solo;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcelable;
import android.os.RemoteException;
import android.text.TextUtils;
import android.view.Surface;
import com.MAVLink.Messages.MAVLinkMessage;
import com.MAVLink.common.msg_statustext;
import com.o3dr.services.android.lib.drone.companion.solo.button.ButtonPacket;
import com.o3dr.services.android.lib.drone.companion.solo.tlv.SoloButtonSetting;
import com.o3dr.services.android.lib.drone.companion.solo.tlv.SoloButtonSettingSetter;
import com.o3dr.services.android.lib.drone.companion.solo.tlv.TLVPacket;
import com.o3dr.services.android.lib.drone.property.DroneAttribute;
import com.o3dr.services.android.lib.drone.property.State;
import com.o3dr.services.android.lib.model.ICommandListener;
import com.o3dr.services.android.lib.model.action.Action;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.droidplanner.services.android.impl.communication.model.DataLink;
import org.droidplanner.services.android.impl.core.drone.DroneInterfaces;
import org.droidplanner.services.android.impl.core.drone.LogMessageListener;
import org.droidplanner.services.android.impl.core.drone.autopilot.apm.ArduCopter;
import org.droidplanner.services.android.impl.core.drone.autopilot.apm.solo.SoloComp;
import org.droidplanner.services.android.impl.core.drone.variables.ApmModes;
import org.droidplanner.services.android.impl.core.drone.variables.StreamRates;
import org.droidplanner.services.android.impl.core.firmware.FirmwareType;
import org.droidplanner.services.android.impl.core.model.AutopilotWarningParser;
import org.droidplanner.services.android.impl.utils.SoloApiUtils;
import timber.log.Timber;

public class ArduSolo
extends ArduCopter {
    private static final String PIXHAWK_SERIAL_NUMBER_REGEX = ".*PX4v2 (([0-9A-F]{8}) ([0-9A-F]{8}) ([0-9A-F]{8}))";
    private static final Pattern PIXHAWK_SERIAL_NUMBER_PATTERN = Pattern.compile(".*PX4v2 (([0-9A-F]{8}) ([0-9A-F]{8}) ([0-9A-F]{8}))");
    private static final String SERIAL_NUMBER_LABEL = "serial_number";
    private final Runnable disconnectSoloCompTask = new Runnable(){

        @Override
        public void run() {
            if (ArduSolo.this.soloComp.isConnected()) {
                ArduSolo.this.soloComp.stop();
            }
            ArduSolo.this.handler.removeCallbacks(ArduSolo.this.disconnectSoloCompTask);
        }
    };
    private String pixhawkSerialNumber;
    private final SoloComp soloComp;

    public ArduSolo(String droneId, Context context, DataLink.DataLinkProvider<MAVLinkMessage> mavClient, Handler handler, AutopilotWarningParser warningParser, LogMessageListener logListener) {
        super(droneId, context, mavClient, handler, warningParser, logListener);
        this.soloComp = new SoloComp(context, handler, mavClient);
        this.soloComp.setListener(new SoloComp.SoloCompListener(){

            @Override
            public void onConnected() {
                if (ArduSolo.this.isConnected()) {
                    ArduSolo.this.notifyDroneEvent(DroneInterfaces.DroneEventsType.CONNECTED);
                }
            }

            @Override
            public void onDisconnected() {
                ArduSolo.this.notifyDroneEvent(DroneInterfaces.DroneEventsType.DISCONNECTED);
            }

            @Override
            public void onTlvPacketReceived(TLVPacket packet) {
                switch (packet.getMessageType()) {
                    case 2003: {
                        break;
                    }
                    case 5: 
                    case 6: {
                        break;
                    }
                    case 5005: {
                        ArduSolo.this.notifyAttributeListener("com.o3dr.services.android.lib.drone.companion.solo.event.GOPRO_STATE_UPDATED");
                        break;
                    }
                    case 5006: {
                        ArduSolo.this.notifyAttributeListener("com.o3dr.services.android.lib.drone.companion.solo.event.GOPRO_STATE_V2_UPDATED");
                        break;
                    }
                    default: {
                        Bundle messageInfo = new Bundle();
                        messageInfo.putParcelable("com.o3dr.services.android.lib.drone.companion.solo.event.extra.EXTRA_SOLO_MESSAGE_DATA", (Parcelable)packet);
                        ArduSolo.this.notifyAttributeListener("com.o3dr.services.android.lib.drone.companion.solo.event.SOLO_MESSAGE_RECEIVED", messageInfo);
                    }
                }
            }

            @Override
            public void onPresetButtonLoaded(int buttonType, SoloButtonSetting buttonSettings) {
                ArduSolo.this.notifyAttributeListener("com.o3dr.services.android.lib.drone.companion.solo.event.SOLO_BUTTON_SETTINGS_UPDATED", null);
            }

            @Override
            public void onWifiInfoUpdated(String wifiName, String wifiPassword) {
                ArduSolo.this.notifyAttributeListener("com.o3dr.services.android.lib.drone.companion.solo.event.SOLO_WIFI_SETTINGS_UPDATED", null);
            }

            @Override
            public void onButtonPacketReceived(ButtonPacket packet) {
                Bundle eventInfo = new Bundle();
                eventInfo.putParcelable("com.o3dr.services.android.lib.drone.companion.solo.event.extra.EXTRA_SOLO_BUTTON_EVENT", (Parcelable)packet);
                ArduSolo.this.notifyAttributeListener("com.o3dr.services.android.lib.drone.companion.solo.event.SOLO_BUTTON_EVENT_RECEIVED", eventInfo);
            }

            @Override
            public void onTxPowerComplianceCountryUpdated(String compliantCountry) {
                Bundle eventInfo = new Bundle(1);
                eventInfo.putString("com.o3dr.services.android.lib.drone.companion.solo.event.extra.EXTRA_SOLO_TX_POWER_COMPLIANT_COUNTRY", compliantCountry);
                ArduSolo.this.notifyAttributeListener("com.o3dr.services.android.lib.drone.companion.solo.event.SOLO_TX_POWER_COMPLIANCE_COUNTRY_UPDATED", eventInfo);
            }

            @Override
            public void onVersionsUpdated() {
                Bundle eventInfo = new Bundle();
                eventInfo.putString("com.o3dr.services.android.lib.drone.companion.solo.event.extra.EXTRA_SOLO_VEHICLE_VERSION", ArduSolo.this.soloComp.getVehicleVersion());
                eventInfo.putString("com.o3dr.services.android.lib.drone.companion.solo.event.extra.EXTRA_SOLO_AUTOPILOT_VERSION", ArduSolo.this.soloComp.getAutopilotVersion());
                eventInfo.putString("com.o3dr.services.android.lib.drone.companion.solo.event.extra.EXTRA_SOLO_GIMBAL_VERSION", ArduSolo.this.soloComp.getGimbalVersion());
                eventInfo.putString("com.o3dr.services.android.lib.drone.companion.solo.event.extra.EXTRA_SOLO_CONTROLLER_VERSION", ArduSolo.this.soloComp.getControllerVersion());
                eventInfo.putString("com.o3dr.services.android.lib.drone.companion.solo.event.extra.EXTRA_SOLO_CONTROLLER_FIRMWARE_VERSION", ArduSolo.this.soloComp.getControllerFirmwareVersion());
                ArduSolo.this.notifyAttributeListener("com.o3dr.services.android.lib.drone.companion.solo.event.SOLO_VERSIONS_UPDATED", eventInfo);
            }

            @Override
            public void onControllerEvent(String event, Bundle eventInfo) {
                ArduSolo.this.notifyAttributeListener(event, eventInfo);
            }
        });
    }

    @Override
    public void destroy() {
        super.destroy();
        this.soloComp.destroy();
    }

    public SoloComp getSoloComp() {
        return this.soloComp;
    }

    @Override
    public StreamRates getStreamRates() {
        return null;
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public void setType(int type) {
    }

    @Override
    public FirmwareType getFirmwareType() {
        return FirmwareType.ARDU_SOLO;
    }

    @Override
    public boolean isConnected() {
        return this.soloComp.isConnected() && super.isConnected();
    }

    @Override
    public DroneAttribute getAttribute(String attributeType) {
        switch (attributeType) {
            case "com.o3dr.services.android.lib.drone.companion.solo.attribute.SOLO_STATE": {
                return SoloApiUtils.getSoloLinkState(this);
            }
            case "com.o3dr.services.android.lib.drone.companion.solo.attribute.SOLO_GOPRO_STATE": {
                return this.soloComp.getGoproState();
            }
            case "com.o3dr.services.android.lib.drone.companion.solo.attribute.SOLO_GOPRO_STATE_V2": {
                return this.soloComp.getGoproStateV2();
            }
            case "com.o3dr.services.android.lib.attribute.STATE": {
                State stateAttr = (State)super.getAttribute(attributeType);
                stateAttr.addToVehicleUid(SERIAL_NUMBER_LABEL, this.pixhawkSerialNumber);
                stateAttr.addToVehicleUid("solo_mac_address", this.soloComp.getSoloMacAddress());
                stateAttr.addToVehicleUid("controller_mac_address", this.soloComp.getControllerMacAddress());
                return stateAttr;
            }
        }
        return super.getAttribute(attributeType);
    }

    protected void resetVideoManager() {
        this.videoMgr.reset();
    }

    @Override
    public void startVideoStream(Bundle videoProps, String appId, String newVideoTag, Surface videoSurface, ICommandListener listener) {
        if (!this.soloComp.hasStreamingPermission()) {
            this.postErrorEvent(2, listener);
            return;
        }
        super.startVideoStream(videoProps, appId, newVideoTag, videoSurface, listener);
    }

    protected void postErrorEvent(final int error, final ICommandListener listener) {
        if (this.handler != null && listener != null) {
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        listener.onError(error);
                    }
                    catch (RemoteException e) {
                        Timber.e((Throwable)e, (String)e.getMessage(), (Object[])new Object[0]);
                    }
                }
            });
        }
    }

    @Override
    public void notifyDroneEvent(DroneInterfaces.DroneEventsType event) {
        switch (event) {
            case HEARTBEAT_FIRST: 
            case CONNECTED: {
                Timber.i((String)("Vehicle " + event.name().toLowerCase()), (Object[])new Object[0]);
                if (this.soloComp.isConnected()) break;
                this.resetVideoManager();
                this.soloComp.start();
                return;
            }
            case DISCONNECTED: {
                Timber.i((String)"Vehicle disconnected.", (Object[])new Object[0]);
                if (!this.soloComp.isConnected()) break;
                this.soloComp.stop();
                this.resetVideoManager();
                return;
            }
            case HEARTBEAT_TIMEOUT: {
                Timber.i((String)"Vehicle heartbeat timed out.", (Object[])new Object[0]);
                if (!this.soloComp.isConnected()) break;
                this.handler.postDelayed(this.disconnectSoloCompTask, 5000L);
                break;
            }
            case HEARTBEAT_RESTORED: {
                Timber.i((String)"Vehicle heartbeat restored.", (Object[])new Object[0]);
                this.handler.removeCallbacks(this.disconnectSoloCompTask);
                if (!this.soloComp.isConnected()) {
                    this.soloComp.start();
                    break;
                }
                this.soloComp.refreshState();
            }
        }
        super.notifyDroneEvent(event);
    }

    @Override
    public boolean executeAsyncAction(Action action, ICommandListener listener) {
        String type = action.getType();
        Bundle data = action.getData();
        switch (type) {
            case "com.o3dr.services.android.lib.drone.companion.solo.action.SEND_MESSAGE": {
                TLVPacket messageData = (TLVPacket)data.getParcelable("extra_message_data");
                if (messageData != null) {
                    SoloApiUtils.sendSoloLinkMessage(this, messageData, listener);
                }
                return true;
            }
            case "com.o3dr.services.android.lib.drone.companion.solo.action.config.UPDATE_WIFI_SETTINGS": {
                String wifiSsid = data.getString("extra_wifi_ssid");
                String wifiPassword = data.getString("extra_wifi_password");
                SoloApiUtils.updateSoloLinkWifiSettings(this, wifiSsid, wifiPassword, listener);
                return true;
            }
            case "com.o3dr.services.android.lib.drone.companion.solo.action.config.UPDATE_BUTTON_SETTINGS": {
                SoloButtonSettingSetter buttonSettings = (SoloButtonSettingSetter)data.getParcelable("extra_button_settings");
                if (buttonSettings != null) {
                    SoloApiUtils.updateSoloLinkButtonSettings(this, buttonSettings, listener);
                }
                return true;
            }
            case "com.o3dr.services.android.lib.drone.companion.solo.action.config.UPDATE_CONTROLLER_MODE": {
                int mode = data.getInt("extra_controller_mode");
                SoloApiUtils.updateSoloLinkControllerMode(this, mode, listener);
                return true;
            }
            case "com.o3dr.services.android.lib.drone.companion.solo.action.config.UPDATE_TX_POWER_COMPLIANCE_COUNTRY": {
                String compliantCountry = data.getString("extra_tx_power_compliant_country_code");
                SoloApiUtils.updateSoloLinkTxPowerComplianceCountry(this, compliantCountry, listener);
                return true;
            }
            case "com.o3dr.services.android.lib.drone.companion.solo.action.config.REFRESH_SOLO_VERSIONS": {
                this.soloComp.refreshSoloVersions();
                return true;
            }
            case "com.o3dr.services.android.lib.drone.companion.solo.action.config.UPDATE_CONTROLLER_UNIT": {
                String unit = data.getString("extra_controller_unit");
                SoloApiUtils.updateSoloControllerUnit(this, unit, listener);
                return true;
            }
        }
        return super.executeAsyncAction(action, listener);
    }

    @Override
    protected boolean isFeatureSupported(String featureId) {
        switch (featureId) {
            case "feature_solo_video_streaming": 
            case "feature_compass_calibration": 
            case "feature_kill_switch": {
                return true;
            }
        }
        return super.isFeatureSupported(featureId);
    }

    @Override
    protected void processSignalUpdate(int rxerrors, int fixed, short rssi, short remrssi, short txbuf, short noise, short remnoise) {
        double unsignedRemRssi = remrssi & 0xFF;
        this.signal.setValid(true);
        this.signal.setRxerrors(rxerrors & 0xFFFF);
        this.signal.setFixed(fixed & 0xFFFF);
        this.signal.setRssi(rssi & 0xFF);
        this.signal.setRemrssi(unsignedRemRssi);
        this.signal.setNoise(noise & 0xFF);
        this.signal.setRemnoise(remnoise & 0xFF);
        this.signal.setTxbuf(txbuf & 0xFF);
        double signalStrength = unsignedRemRssi <= 127.0 ? unsignedRemRssi : unsignedRemRssi - 256.0;
        this.signal.setSignalStrength(signalStrength);
        this.notifyDroneEvent(DroneInterfaces.DroneEventsType.RADIO);
    }

    @Override
    protected void processStatusText(msg_statustext statusText) {
        Matcher matcher;
        super.processStatusText(statusText);
        String message = statusText.getText();
        if (!TextUtils.isEmpty((CharSequence)message) && (matcher = PIXHAWK_SERIAL_NUMBER_PATTERN.matcher(message)).matches()) {
            Timber.i((String)"Received serial number: %s", (Object[])new Object[]{message});
            String serialNumber = matcher.group(2) + matcher.group(3) + matcher.group(4);
            if (!serialNumber.equalsIgnoreCase(this.pixhawkSerialNumber)) {
                this.pixhawkSerialNumber = serialNumber;
                this.notifyAttributeListener("com.o3dr.services.android.lib.attribute.event.STATE_VEHICLE_UID");
            }
        }
    }

    @Override
    protected boolean brakeVehicle(ICommandListener listener) {
        this.getState().changeFlightMode(ApmModes.ROTOR_BRAKE, listener);
        return true;
    }
}

