/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.core.drone.autopilot.apm;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import com.MAVLink.Messages.MAVLinkMessage;
import com.MAVLink.ardupilotmega.msg_camera_feedback;
import com.MAVLink.ardupilotmega.msg_mount_configure;
import com.MAVLink.ardupilotmega.msg_mount_status;
import com.MAVLink.ardupilotmega.msg_radio;
import com.MAVLink.common.msg_named_value_int;
import com.MAVLink.common.msg_raw_imu;
import com.MAVLink.common.msg_rc_channels_raw;
import com.MAVLink.common.msg_servo_output_raw;
import com.MAVLink.common.msg_statustext;
import com.MAVLink.common.msg_sys_status;
import com.MAVLink.common.msg_vfr_hud;
import com.github.zafarkhaja.semver.Version;
import com.o3dr.services.android.lib.coordinate.LatLong;
import com.o3dr.services.android.lib.coordinate.LatLongAlt;
import com.o3dr.services.android.lib.drone.mission.Mission;
import com.o3dr.services.android.lib.drone.property.DroneAttribute;
import com.o3dr.services.android.lib.drone.property.Parameter;
import com.o3dr.services.android.lib.drone.property.Parameters;
import com.o3dr.services.android.lib.drone.property.VehicleMode;
import com.o3dr.services.android.lib.model.AbstractCommandListener;
import com.o3dr.services.android.lib.model.ICommandListener;
import com.o3dr.services.android.lib.model.action.Action;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.droidplanner.services.android.impl.communication.model.DataLink;
import org.droidplanner.services.android.impl.core.MAVLink.MavLinkParameters;
import org.droidplanner.services.android.impl.core.MAVLink.WaypointManager;
import org.droidplanner.services.android.impl.core.MAVLink.command.doCmd.MavLinkDoCmds;
import org.droidplanner.services.android.impl.core.drone.DroneInterfaces;
import org.droidplanner.services.android.impl.core.drone.LogMessageListener;
import org.droidplanner.services.android.impl.core.drone.autopilot.apm.variables.APMHeartBeat;
import org.droidplanner.services.android.impl.core.drone.autopilot.generic.GenericMavLinkDrone;
import org.droidplanner.services.android.impl.core.drone.variables.ApmModes;
import org.droidplanner.services.android.impl.core.drone.variables.Camera;
import org.droidplanner.services.android.impl.core.drone.variables.GuidedPoint;
import org.droidplanner.services.android.impl.core.drone.variables.HeartBeat;
import org.droidplanner.services.android.impl.core.drone.variables.Magnetometer;
import org.droidplanner.services.android.impl.core.drone.variables.RC;
import org.droidplanner.services.android.impl.core.drone.variables.calibration.AccelCalibration;
import org.droidplanner.services.android.impl.core.drone.variables.calibration.MagnetometerCalibrationImpl;
import org.droidplanner.services.android.impl.core.mission.MissionImpl;
import org.droidplanner.services.android.impl.core.model.AutopilotWarningParser;
import org.droidplanner.services.android.impl.utils.CommonApiUtils;
import timber.log.Timber;

public abstract class ArduPilot
extends GenericMavLinkDrone {
    public static final int AUTOPILOT_COMPONENT_ID = 1;
    public static final int ARTOO_COMPONENT_ID = 0;
    public static final int TELEMETRY_RADIO_COMPONENT_ID = 68;
    public static final String FIRMWARE_VERSION_NUMBER_REGEX = "\\d+(\\.\\d{1,2})?";
    private final RC rc;
    private final MissionImpl missionImpl;
    private final GuidedPoint guidedPoint;
    private final AccelCalibration accelCalibrationSetup;
    private final WaypointManager waypointManager;
    private final Magnetometer mag;
    private final Camera footprints;
    private final MagnetometerCalibrationImpl magCalibration;
    protected Version firmwareVersionNumber = Version.forIntegers((int)0, (int)0, (int)0);

    public ArduPilot(String droneId, Context context, DataLink.DataLinkProvider<MAVLinkMessage> mavClient, Handler handler, AutopilotWarningParser warningParser, LogMessageListener logListener) {
        super(droneId, context, handler, mavClient, warningParser, logListener);
        this.waypointManager = new WaypointManager(this, handler);
        this.rc = new RC(this);
        this.missionImpl = new MissionImpl(this);
        this.guidedPoint = new GuidedPoint(this, handler);
        this.accelCalibrationSetup = new AccelCalibration(this, handler);
        this.magCalibration = new MagnetometerCalibrationImpl(this);
        this.mag = new Magnetometer(this);
        this.footprints = new Camera(this);
    }

    @Override
    protected HeartBeat initHeartBeat(Handler handler) {
        return new APMHeartBeat(this, handler);
    }

    protected void setAltitudeGroundAndAirSpeeds(double altitude, double groundSpeed, double airSpeed, double climb) {
        if (this.altitude.getAltitude() != altitude) {
            this.altitude.setAltitude(altitude);
            this.notifyDroneEvent(DroneInterfaces.DroneEventsType.ALTITUDE);
        }
        if (this.speed.getGroundSpeed() != groundSpeed || this.speed.getAirSpeed() != airSpeed || this.speed.getVerticalSpeed() != climb) {
            this.speed.setGroundSpeed(groundSpeed);
            this.speed.setAirSpeed(airSpeed);
            this.speed.setVerticalSpeed(climb);
            this.notifyDroneEvent(DroneInterfaces.DroneEventsType.SPEED);
        }
    }

    @Override
    public WaypointManager getWaypointManager() {
        return this.waypointManager;
    }

    @Override
    public MissionImpl getMission() {
        return this.missionImpl;
    }

    @Override
    public GuidedPoint getGuidedPoint() {
        return this.guidedPoint;
    }

    @Override
    public AccelCalibration getCalibrationSetup() {
        return this.accelCalibrationSetup;
    }

    @Override
    public MagnetometerCalibrationImpl getMagnetometerCalibration() {
        return this.magCalibration;
    }

    @Override
    public Camera getCamera() {
        return this.footprints;
    }

    @Override
    public DroneAttribute getAttribute(String attributeType) {
        if (!TextUtils.isEmpty((CharSequence)attributeType)) {
            switch (attributeType) {
                case "com.o3dr.services.android.lib.attribute.MISSION": {
                    return CommonApiUtils.getMission(this);
                }
                case "com.o3dr.services.android.lib.attribute.GUIDED_STATE": {
                    return CommonApiUtils.getGuidedState(this);
                }
                case "com.o3dr.services.android.lib.attribute.MAGNETOMETER_CALIBRATION_STATUS": {
                    return CommonApiUtils.getMagnetometerCalibrationStatus(this);
                }
            }
        }
        return super.getAttribute(attributeType);
    }

    @Override
    public boolean executeAsyncAction(Action action, final ICommandListener listener) {
        String type = action.getType();
        Bundle data = action.getData();
        if (data == null) {
            data = new Bundle();
        }
        switch (type) {
            case "com.o3dr.services.android.action.LOAD_WAYPOINTS": {
                CommonApiUtils.loadWaypoints(this);
                return true;
            }
            case "com.o3dr.services.android.action.SET_MISSION": {
                data.setClassLoader(Mission.class.getClassLoader());
                Mission mission = (Mission)data.getParcelable("extra_mission");
                boolean pushToDrone = data.getBoolean("extra_push_to_drone");
                CommonApiUtils.setMission(this, mission, pushToDrone);
                return true;
            }
            case "com.o3dr.services.android.action.START_MISSION": {
                boolean forceModeChange = data.getBoolean("extra_force_mode_change");
                boolean forceArm = data.getBoolean("extra_force_arm");
                CommonApiUtils.startMission(this, forceModeChange, forceArm, listener);
                return true;
            }
            case "com.o3dr.services.android.action.EPM_COMMAND": {
                boolean release = data.getBoolean("com.o3dr.services.androidextra_epm_release");
                CommonApiUtils.epmCommand(this, release, listener);
                return true;
            }
            case "com.o3dr.services.android.action.TRIGGER_CAMERA": {
                CommonApiUtils.triggerCamera(this);
                return true;
            }
            case "com.o3dr.services.android.action.SET_ROI": {
                LatLongAlt roi = (LatLongAlt)data.getParcelable("extra_set_roi_lat_long_alt");
                if (roi != null) {
                    MavLinkDoCmds.setROI(this, roi, listener);
                }
                return true;
            }
            case "com.o3dr.services.android.action.SET_RELAY": {
                int relayNumber = data.getInt("extra_relay_number");
                boolean isOn = data.getBoolean("extra_is_relay_on");
                MavLinkDoCmds.setRelay(this, relayNumber, isOn, listener);
                return true;
            }
            case "com.o3dr.services.android.action.SET_SERVO": {
                int channel = data.getInt("extra_servo_channel");
                int pwm = data.getInt("extra_servo_PWM");
                MavLinkDoCmds.setServo(this, channel, pwm, listener);
                return true;
            }
            case "com.o3dr.services.android.action.SEND_GUIDED_POINT": {
                data.setClassLoader(LatLong.class.getClassLoader());
                boolean force = data.getBoolean("extra_force_guided_point");
                LatLong guidedPoint = (LatLong)data.getParcelable("extra_guided_point");
                CommonApiUtils.sendGuidedPoint(this, guidedPoint, force, listener);
                return true;
            }
            case "com.o3dr.services.android.lib.drone.action.control.action.LOOK_AT_TARGET": {
                boolean force = data.getBoolean("extra_force_guided_point");
                LatLongAlt lookAtTarget = (LatLongAlt)data.getParcelable("extra_look_at_target");
                CommonApiUtils.sendLookAtTarget(this, lookAtTarget, force, listener);
                return true;
            }
            case "com.o3dr.services.android.action.SET_GUIDED_ALTITUDE": {
                double guidedAltitude = data.getDouble("extra_altitude");
                CommonApiUtils.setGuidedAltitude(this, guidedAltitude);
                return true;
            }
            case "com.o3dr.services.android.action.REFRESH_PARAMETERS": {
                CommonApiUtils.refreshParameters(this);
                return true;
            }
            case "com.o3dr.services.android.action.WRITE_PARAMETERS": {
                data.setClassLoader(Parameters.class.getClassLoader());
                Parameters parameters = (Parameters)data.getParcelable("extra_parameters");
                CommonApiUtils.writeParameters(this, parameters);
                return true;
            }
            case "com.o3dr.services.android.action.SET_VEHICLE_HOME": {
                LatLongAlt homeLoc = (LatLongAlt)data.getParcelable("extra_vehicle_home_location");
                if (homeLoc != null) {
                    MavLinkDoCmds.setVehicleHome(this, homeLoc, new AbstractCommandListener(){

                        @Override
                        public void onSuccess() {
                            CommonApiUtils.postSuccessEvent(listener);
                            ArduPilot.this.requestHomeUpdate();
                        }

                        @Override
                        public void onError(int executionError) {
                            CommonApiUtils.postErrorEvent(executionError, listener);
                            ArduPilot.this.requestHomeUpdate();
                        }

                        @Override
                        public void onTimeout() {
                            CommonApiUtils.postTimeoutEvent(listener);
                            ArduPilot.this.requestHomeUpdate();
                        }
                    });
                } else {
                    CommonApiUtils.postErrorEvent(4, listener);
                }
                return true;
            }
            case "com.o3dr.services.android.action.START_IMU_CALIBRATION": {
                CommonApiUtils.startIMUCalibration(this, listener);
                return true;
            }
            case "com.o3dr.services.android.action.SEND_IMU_CALIBRATION_ACK": {
                int imuAck = data.getInt("extra_step");
                CommonApiUtils.sendIMUCalibrationAck(this, imuAck);
                return true;
            }
            case "com.o3dr.services.android.action.START_MAGNETOMETER_CALIBRATION": {
                boolean retryOnFailure = data.getBoolean("extra_retry_on_failure", false);
                boolean saveAutomatically = data.getBoolean("extra_save_automatically", true);
                int startDelay = data.getInt("extra_start_delay", 0);
                CommonApiUtils.startMagnetometerCalibration(this, retryOnFailure, saveAutomatically, startDelay);
                return true;
            }
            case "com.o3dr.services.android.action.CANCEL_MAGNETOMETER_CALIBRATION": {
                CommonApiUtils.cancelMagnetometerCalibration(this);
                return true;
            }
            case "com.o3dr.services.android.action.ACCEPT_MAGNETOMETER_CALIBRATION": {
                CommonApiUtils.acceptMagnetometerCalibration(this);
                return true;
            }
            case "com.o3dr.services.android.action.gimbal.SET_GIMBAL_ORIENTATION": {
                float pitch = data.getFloat("gimbal_pitch");
                float roll = data.getFloat("gimbal_roll");
                float yaw = data.getFloat("gimbal_yaw");
                MavLinkDoCmds.setGimbalOrientation(this, pitch, roll, yaw, listener);
                return true;
            }
            case "com.o3dr.services.android.action.gimbal.RESET_GIMBAL_MOUNT_MODE": 
            case "com.o3dr.services.android.action.gimbal.SET_GIMBAL_MOUNT_MODE": {
                int mountMode = data.getInt("gimbal_mount_mode", 3);
                Timber.i((String)"Setting gimbal mount mode: %d", (Object[])new Object[]{mountMode});
                Parameter mountParam = this.getParameterManager().getParameter("MNT_MODE");
                if (mountParam == null) {
                    msg_mount_configure msg = new msg_mount_configure();
                    msg.target_system = this.getSysid();
                    msg.target_component = this.getCompid();
                    msg.mount_mode = (byte)mountMode;
                    msg.stab_pitch = 0;
                    msg.stab_roll = 0;
                    msg.stab_yaw = 0;
                    this.getMavClient().sendMessage((MAVLinkMessage)msg, listener);
                } else {
                    MavLinkParameters.sendParameter(this, "MNT_MODE", 1, mountMode);
                }
                return true;
            }
        }
        return super.executeAsyncAction(action, listener);
    }

    @Override
    protected boolean enableManualControl(Bundle data, ICommandListener listener) {
        CommonApiUtils.postErrorEvent(3, listener);
        return true;
    }

    @Override
    protected boolean performArming(Bundle data, ICommandListener listener) {
        boolean doArm = data.getBoolean("extra_arm");
        boolean emergencyDisarm = data.getBoolean("extra_emergency_disarm");
        CommonApiUtils.arm(this, doArm, emergencyDisarm, listener);
        return true;
    }

    @Override
    protected boolean setVehicleMode(Bundle data, ICommandListener listener) {
        data.setClassLoader(VehicleMode.class.getClassLoader());
        VehicleMode newMode = (VehicleMode)data.getParcelable("extra_vehicle_mode");
        CommonApiUtils.changeVehicleMode(this, newMode, listener);
        return true;
    }

    @Override
    protected boolean setVelocity(Bundle data, ICommandListener listener) {
        CommonApiUtils.postErrorEvent(3, listener);
        return true;
    }

    @Override
    protected boolean performTakeoff(Bundle data, ICommandListener listener) {
        double takeoffAltitude = data.getDouble("extra_altitude");
        CommonApiUtils.doGuidedTakeoff(this, takeoffAltitude, listener);
        return true;
    }

    @Override
    public void onMavLinkMessageReceived(MAVLinkMessage message) {
        if (message.sysid != this.getSysid()) {
            return;
        }
        int compId = message.compid;
        if (compId != 1 && compId != 0 && compId != 68) {
            return;
        }
        if (!this.getParameterManager().processMessage(message)) {
            this.getWaypointManager().processMessage(message);
            this.getCalibrationSetup().processMessage(message);
            switch (message.msgid) {
                case 253: {
                    msg_statustext msg_statustext2 = (msg_statustext)message;
                    this.processStatusText(msg_statustext2);
                    break;
                }
                case 74: {
                    this.processVfrHud((msg_vfr_hud)message);
                    break;
                }
                case 27: {
                    msg_raw_imu msg_imu = (msg_raw_imu)message;
                    this.mag.newData(msg_imu);
                    break;
                }
                case 166: {
                    msg_radio m_radio = (msg_radio)message;
                    this.processSignalUpdate(m_radio.rxerrors, m_radio.fixed, m_radio.rssi, m_radio.remrssi, m_radio.txbuf, m_radio.noise, m_radio.remnoise);
                    break;
                }
                case 35: {
                    this.rc.setRcInputValues((msg_rc_channels_raw)message);
                    break;
                }
                case 36: {
                    this.rc.setRcOutputValues((msg_servo_output_raw)message);
                    break;
                }
                case 180: {
                    this.getCamera().newImageLocation((msg_camera_feedback)message);
                    break;
                }
                case 158: {
                    this.processMountStatus((msg_mount_status)message);
                    break;
                }
                case 252: {
                    this.processNamedValueInt((msg_named_value_int)message);
                    break;
                }
                case 191: 
                case 192: {
                    this.getMagnetometerCalibration().processCalibrationMessage(message);
                    break;
                }
            }
        }
        super.onMavLinkMessageReceived(message);
    }

    @Override
    protected void processSysStatus(msg_sys_status m_sys) {
        super.processSysStatus(m_sys);
        this.checkControlSensorsHealth(m_sys);
    }

    @Override
    protected final void setFirmwareVersion(String message) {
        super.setFirmwareVersion(message);
        this.setFirmwareVersionNumber(message);
    }

    protected Version getFirmwareVersionNumber() {
        return this.firmwareVersionNumber;
    }

    private void setFirmwareVersionNumber(String message) {
        this.firmwareVersionNumber = ArduPilot.extractVersionNumber(message);
    }

    protected static Version extractVersionNumber(String firmwareVersion) {
        Version version = Version.forIntegers((int)0, (int)0, (int)0);
        Pattern pattern = Pattern.compile(FIRMWARE_VERSION_NUMBER_REGEX);
        Matcher matcher = pattern.matcher(firmwareVersion);
        if (matcher.find()) {
            String versionNumber = matcher.group(0) + ".0";
            try {
                version = Version.valueOf((String)versionNumber);
            }
            catch (Exception e) {
                Timber.e((Throwable)e, (String)"Firmware version invalid", (Object[])new Object[0]);
            }
        }
        return version;
    }

    private void checkControlSensorsHealth(msg_sys_status sysStatus) {
        boolean isRCFailsafe;
        boolean bl = isRCFailsafe = (sysStatus.onboard_control_sensors_health & 0x10000L) == 0L;
        if (isRCFailsafe) {
            this.getState().parseAutopilotError("RC FAILSAFE");
        }
    }

    protected void processVfrHud(msg_vfr_hud vfrHud) {
        if (vfrHud == null) {
            return;
        }
        this.setAltitudeGroundAndAirSpeeds(vfrHud.alt, vfrHud.groundspeed, vfrHud.airspeed, vfrHud.climb);
    }

    protected void processMountStatus(msg_mount_status mountStatus) {
        this.footprints.updateMountOrientation(mountStatus);
        Bundle eventInfo = new Bundle(3);
        eventInfo.putFloat("com.o3dr.services.android.lib.attribute.event.extra.EXTRA_GIMBAL_ORIENTATION_PITCH", (float)mountStatus.pointing_a / 100.0f);
        eventInfo.putFloat("com.o3dr.services.android.lib.attribute.event.extra.EXTRA_GIMBAL_ORIENTATION_ROLL", (float)mountStatus.pointing_b / 100.0f);
        eventInfo.putFloat("com.o3dr.services.android.lib.attribute.event.extra.EXTRA_GIMBAL_ORIENTATION_YAW", (float)mountStatus.pointing_c / 100.0f);
        this.notifyAttributeListener("com.o3dr.services.android.lib.attribute.event.GIMBAL_ORIENTATION_UPDATED", eventInfo);
    }

    private void processNamedValueInt(msg_named_value_int message) {
        if (message == null) {
            return;
        }
        switch (message.getName()) {
            case "ARMMASK": {
                ApmModes vehicleMode = this.getState().getMode();
                if (!ApmModes.isCopter(vehicleMode.getType())) break;
                int value = message.value;
                boolean isReadyToArm = (value & 1 << (int)vehicleMode.getNumber()) != 0;
                String armReadinessMsg = isReadyToArm ? "READY TO ARM" : "UNREADY FOR ARMING";
                this.logMessage(4, armReadinessMsg);
            }
        }
    }

    protected void processStatusText(msg_statustext statusText) {
        String message = statusText.getText();
        if (TextUtils.isEmpty((CharSequence)message)) {
            return;
        }
        if (message.startsWith("ArduCopter") || message.startsWith("ArduPlane") || message.startsWith("ArduRover") || message.startsWith("Solo") || message.startsWith("APM:Copter") || message.startsWith("APM:Plane") || message.startsWith("APM:Rover")) {
            this.setFirmwareVersion(message);
        } else if (!this.getState().parseAutopilotError(message)) {
            int logLevel;
            switch (statusText.severity) {
                case 4: {
                    logLevel = 6;
                    break;
                }
                case 3: {
                    logLevel = 5;
                    break;
                }
                case 2: {
                    logLevel = 4;
                    break;
                }
                default: {
                    logLevel = 2;
                    break;
                }
                case 5: {
                    logLevel = 3;
                }
            }
            this.logMessage(logLevel, message);
        }
    }

    public Double getBattDischarge(double battRemain) {
        Parameter battCap = this.getParameterManager().getParameter("BATT_CAPACITY");
        if (battCap == null || battRemain == -1.0) {
            return null;
        }
        return (1.0 - battRemain / 100.0) * battCap.getValue();
    }

    @Override
    protected void processBatteryUpdate(double voltage, double remain, double current) {
        if (this.battery.getBatteryRemain() != remain) {
            this.battery.setBatteryDischarge(this.getBattDischarge(remain));
        }
        super.processBatteryUpdate(voltage, remain, current);
    }
}

