/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.core.drone;

import android.os.Handler;
import android.os.RemoteException;
import com.o3dr.services.android.lib.model.ICommandListener;
import org.droidplanner.services.android.impl.core.drone.autopilot.MavLinkDrone;
import timber.log.Timber;

public class DroneVariable<T extends MavLinkDrone> {
    static int UNSIGNED_BYTE_MIN_VALUE = 0;
    static int UNSIGNED_BYTE_MAX_VALUE = 255;
    protected T myDrone;

    public DroneVariable(T myDrone) {
        this.myDrone = myDrone;
    }

    protected void postSuccessEvent(Handler handler, final ICommandListener listener) {
        if (handler != null && listener != null) {
            handler.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        listener.onSuccess();
                    }
                    catch (RemoteException e) {
                        Timber.e((Throwable)e, (String)e.getMessage(), (Object[])new Object[0]);
                    }
                }
            });
        }
    }

    protected void postErrorEvent(Handler handler, final ICommandListener listener, final int error) {
        if (handler != null && listener != null) {
            handler.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        listener.onError(error);
                    }
                    catch (RemoteException e) {
                        Timber.e((Throwable)e, (String)e.getMessage(), (Object[])new Object[0]);
                    }
                }
            });
        }
    }

    protected void postTimeoutEvent(Handler handler, final ICommandListener listener) {
        if (handler != null && listener != null) {
            handler.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        listener.onTimeout();
                    }
                    catch (RemoteException e) {
                        Timber.e((Throwable)e, (String)e.getMessage(), (Object[])new Object[0]);
                    }
                }
            });
        }
    }

    public static short validateToUnsignedByteRange(int id) {
        if (id < UNSIGNED_BYTE_MIN_VALUE || id > UNSIGNED_BYTE_MAX_VALUE) {
            throw new IllegalArgumentException("Value is outside of the range of an sysid/compid byte: " + id);
        }
        return (short)id;
    }
}

