/*
 * Decompiled with CFR 0.152.
 */
package com.o3dr.services.android.lib.util;

import com.o3dr.services.android.lib.coordinate.LatLong;
import com.o3dr.services.android.lib.coordinate.LatLongAlt;
import java.util.ArrayList;
import java.util.List;

public class MathUtils {
    private static final double RADIUS_OF_EARTH_IN_METERS = 6378137.0;
    public static final int SIGNAL_MAX_FADE_MARGIN = 50;
    public static final int SIGNAL_MIN_FADE_MARGIN = 6;

    public static double getDistance3D(LatLongAlt from, LatLongAlt to) {
        if (from == null || to == null) {
            return -1.0;
        }
        double distance2d = MathUtils.getDistance2D(from, to);
        double distanceSqr = Math.pow(distance2d, 2.0);
        double altitudeSqr = Math.pow(to.getAltitude() - from.getAltitude(), 2.0);
        return Math.sqrt(altitudeSqr + distanceSqr);
    }

    public static double getDistance2D(LatLong from, LatLong to) {
        if (from == null || to == null) {
            return -1.0;
        }
        return 6378137.0 * Math.toRadians(MathUtils.getArcInRadians(from, to));
    }

    public static LatLong addDistance(LatLong from, double xMeters, double yMeters) {
        double lat = from.getLatitude();
        double lon = from.getLongitude();
        double dLat = yMeters / 6378137.0;
        double dLon = xMeters / (6378137.0 * Math.cos(Math.PI * lat / 180.0));
        double latO = lat + dLat * 180.0 / Math.PI;
        double lonO = lon + dLon * 180.0 / Math.PI;
        return new LatLong(latO, lonO);
    }

    public static double getArcInRadians(LatLong from, LatLong to) {
        double latitudeArc = Math.toRadians(from.getLatitude() - to.getLatitude());
        double longitudeArc = Math.toRadians(from.getLongitude() - to.getLongitude());
        double latitudeH = Math.sin(latitudeArc * 0.5);
        latitudeH *= latitudeH;
        double lontitudeH = Math.sin(longitudeArc * 0.5);
        lontitudeH *= lontitudeH;
        double tmp = Math.cos(Math.toRadians(from.getLatitude())) * Math.cos(Math.toRadians(to.getLatitude()));
        return Math.toDegrees(2.0 * Math.asin(Math.sqrt(latitudeH + tmp * lontitudeH)));
    }

    public static int getSignalStrength(double fadeMargin, double remFadeMargin) {
        return (int)(MathUtils.normalize(Math.min(fadeMargin, remFadeMargin), 6.0, 50.0) * 100.0);
    }

    public static double normalize(double value, double min, double max) {
        value = MathUtils.constrain(value, min, max);
        return (value - min) / (max - min);
    }

    private static double constrain(double value, double min, double max) {
        value = Math.max(value, min);
        value = Math.min(value, max);
        return value;
    }

    public static double angleDiff(double a, double b) {
        double diff = Math.IEEEremainder(b - a + 180.0, 360.0);
        if (diff < 0.0) {
            diff += 360.0;
        }
        return diff - 180.0;
    }

    public static double constrainAngle(double x) {
        if ((x = Math.IEEEremainder(x, 360.0)) < 0.0) {
            x += 360.0;
        }
        return x;
    }

    public static double bisectAngle(double a, double b, double alpha) {
        return MathUtils.constrainAngle(a + MathUtils.angleDiff(a, b) * alpha);
    }

    public static double hypot(double altDelta, double distDelta) {
        return Math.hypot(altDelta, distDelta);
    }

    public static double[][] dcmFromEuler(double roll, double pitch, double yaw) {
        double[][] dcm = new double[3][3];
        double cp = Math.cos(pitch);
        double sp = Math.sin(pitch);
        double sr = Math.sin(roll);
        double cr = Math.cos(roll);
        double sy = Math.sin(yaw);
        double cy = Math.cos(yaw);
        dcm[0][0] = cp * cy;
        dcm[1][0] = sr * sp * cy - cr * sy;
        dcm[2][0] = cr * sp * cy + sr * sy;
        dcm[0][1] = cp * sy;
        dcm[1][1] = sr * sp * sy + cr * cy;
        dcm[2][1] = cr * sp * sy - sr * cy;
        dcm[0][2] = -sp;
        dcm[1][2] = sr * cp;
        dcm[2][2] = cr * cp;
        return dcm;
    }

    public static List<LatLong> simplify(List<? extends LatLong> list, double epsilon) {
        int index = 0;
        double dmax = 0.0;
        int lastIndex = list.size() - 1;
        for (int i = 1; i < lastIndex; ++i) {
            double d = MathUtils.pointToLineDistance(list.get(0), list.get(lastIndex), list.get(i));
            if (!(d > dmax)) continue;
            index = i;
            dmax = d;
        }
        ArrayList<LatLong> ResultList = new ArrayList<LatLong>();
        if (dmax > epsilon) {
            List<LatLong> recResults1 = MathUtils.simplify(list.subList(0, index + 1), epsilon);
            List<LatLong> recResults2 = MathUtils.simplify(list.subList(index, lastIndex + 1), epsilon);
            recResults1.remove(recResults1.size() - 1);
            ResultList.addAll(recResults1);
            ResultList.addAll(recResults2);
        } else {
            ResultList.add(list.get(0));
            ResultList.add(list.get(lastIndex));
        }
        return ResultList;
    }

    public static double pointToLineDistance(LatLong L1, LatLong L2, LatLong P) {
        double yy;
        double xx;
        double len_sq;
        double D;
        double A = P.getLatitude() - L1.getLatitude();
        double B = P.getLongitude() - L1.getLongitude();
        double C = L2.getLatitude() - L1.getLatitude();
        double dot = A * C + B * (D = L2.getLongitude() - L1.getLongitude());
        double param = dot / (len_sq = C * C + D * D);
        if (param < 0.0) {
            xx = L1.getLatitude();
            yy = L1.getLongitude();
        } else if (param > 1.0) {
            xx = L2.getLatitude();
            yy = L2.getLongitude();
        } else {
            xx = L1.getLatitude() + param * C;
            yy = L1.getLongitude() + param * D;
        }
        return Math.hypot(xx - P.getLatitude(), yy - P.getLongitude());
    }

    public static double getHeadingFromCoordinates(LatLong fromLoc, LatLong toLoc) {
        double fLat = Math.toRadians(fromLoc.getLatitude());
        double fLng = Math.toRadians(fromLoc.getLongitude());
        double tLat = Math.toRadians(toLoc.getLatitude());
        double tLng = Math.toRadians(toLoc.getLongitude());
        double degree = Math.toDegrees(Math.atan2(Math.sin(tLng - fLng) * Math.cos(tLat), Math.cos(fLat) * Math.sin(tLat) - Math.sin(fLat) * Math.cos(tLat) * Math.cos(tLng - fLng)));
        if (degree >= 0.0) {
            return degree;
        }
        return 360.0 + degree;
    }

    public static LatLong newCoordFromBearingAndDistance(LatLong origin, double bearing, double distance) {
        double lat = origin.getLatitude();
        double lon = origin.getLongitude();
        double lat1 = Math.toRadians(lat);
        double lon1 = Math.toRadians(lon);
        double brng = Math.toRadians(bearing);
        double dr = distance / 6378137.0;
        double lat2 = Math.asin(Math.sin(lat1) * Math.cos(dr) + Math.cos(lat1) * Math.sin(dr) * Math.cos(brng));
        double lon2 = lon1 + Math.atan2(Math.sin(brng) * Math.sin(dr) * Math.cos(lat1), Math.cos(dr) - Math.sin(lat1) * Math.sin(lat2));
        return new LatLong(Math.toDegrees(lat2), Math.toDegrees(lon2));
    }

    public static double getPolylineLength(List<LatLong> gridPoints) {
        double length = 0.0;
        for (int i = 1; i < gridPoints.size(); ++i) {
            LatLong to = gridPoints.get(i - 1);
            if (to == null) continue;
            length += MathUtils.getDistance2D(gridPoints.get(i), to);
        }
        return length;
    }

    public static class Spline {
        private static final float SPLINE_TENSION = 1.6f;
        private LatLong p0;
        private LatLong p0_prime;
        private LatLong a;
        private LatLong b;

        public Spline(LatLong pMinus1, LatLong p0, LatLong p1, LatLong p2) {
            this.p0 = p0;
            this.p0_prime = p1.subtract(pMinus1).dot(0.625);
            LatLong p1_prime = p2.subtract(this.p0).dot(0.625);
            this.a = LatLong.sum(this.p0.dot(2.0), p1.dot(-2.0), this.p0_prime, p1_prime);
            this.b = LatLong.sum(this.p0.dot(-3.0), p1.dot(3.0), this.p0_prime.dot(-2.0), p1_prime.negate());
        }

        public List<LatLong> generateCoordinates(int decimation) {
            ArrayList<LatLong> result = new ArrayList<LatLong>();
            float step = 1.0f / (float)decimation;
            for (float i = 0.0f; i < 1.0f; i += step) {
                result.add(this.evaluate(i));
            }
            return result;
        }

        private LatLong evaluate(float t) {
            float tSquared = t * t;
            float tCubed = tSquared * t;
            return LatLong.sum(this.a.dot(tCubed), this.b.dot(tSquared), this.p0_prime.dot(t), this.p0);
        }
    }

    public static class SplinePath {
        private static final String TAG = SplinePath.class.getSimpleName();
        private static final int SPLINE_DECIMATION = 20;

        public static List<LatLong> process(List<LatLong> points) {
            int pointsCount = points.size();
            if (pointsCount < 4) {
                System.err.println("Not enough points!");
                return points;
            }
            List<LatLong> results = SplinePath.processPath(points);
            results.add(0, points.get(0));
            results.add(points.get(pointsCount - 1));
            return results;
        }

        private static List<LatLong> processPath(List<LatLong> points) {
            ArrayList<LatLong> results = new ArrayList<LatLong>();
            for (int i = 3; i < points.size(); ++i) {
                results.addAll(SplinePath.processPathSegment(points.get(i - 3), points.get(i - 2), points.get(i - 1), points.get(i)));
            }
            return results;
        }

        private static List<LatLong> processPathSegment(LatLong l1, LatLong l2, LatLong l3, LatLong l4) {
            Spline spline = new Spline(l1, l2, l3, l4);
            return spline.generateCoordinates(20);
        }
    }
}

