/*
 * Decompiled with CFR 0.152.
 */
package com.o3dr.services.android.lib.gcs.link;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class LinkConnectionStatus
implements Parcelable {
    public static final String EXTRA_ERROR_CODE = "extra_error_code";
    public static final String EXTRA_ERROR_MSG = "extra_error_message";
    public static final String EXTRA_CONNECTION_TIME = "extra_connection_time";
    public static final String CONNECTED = "CONNECTED";
    public static final String CONNECTING = "CONNECTING";
    public static final String DISCONNECTED = "DISCONNECTED";
    public static final String FAILED = "FAILED";
    public static final int SYSTEM_UNAVAILABLE = -1;
    public static final int LINK_UNAVAILABLE = -2;
    public static final int PERMISSION_DENIED = -3;
    public static final int INVALID_CREDENTIALS = -4;
    public static final int TIMEOUT = -5;
    public static final int ADDRESS_IN_USE = -6;
    public static final int UNKNOWN = -7;
    private final String mStatusCode;
    private final Bundle mExtras;
    public static final Parcelable.Creator<LinkConnectionStatus> CREATOR = new Parcelable.Creator<LinkConnectionStatus>(){

        public LinkConnectionStatus createFromParcel(Parcel source) {
            return new LinkConnectionStatus(source);
        }

        public LinkConnectionStatus[] newArray(int size) {
            return new LinkConnectionStatus[size];
        }
    };

    public LinkConnectionStatus(String statusCode, Bundle extras) {
        this.mStatusCode = statusCode;
        this.mExtras = extras;
    }

    public String getStatusCode() {
        return this.mStatusCode;
    }

    public Bundle getExtras() {
        return this.mExtras;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mStatusCode);
        dest.writeBundle(this.mExtras);
    }

    private LinkConnectionStatus(Parcel in) {
        String statusCode;
        this.mStatusCode = statusCode = in.readString();
        this.mExtras = in.readBundle();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LinkConnectionStatus that = (LinkConnectionStatus)o;
        if (this.mStatusCode != null ? !this.mStatusCode.equals(that.mStatusCode) : that.mStatusCode != null) {
            return false;
        }
        return !(this.mExtras == null ? that.mExtras != null : !this.mExtras.equals(that.mExtras));
    }

    public int hashCode() {
        int result = this.mStatusCode != null ? this.mStatusCode.hashCode() : 0;
        result = 31 * result + (this.mExtras != null ? this.mExtras.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ConnectionResult{mStatusCode='" + this.mStatusCode + '\'' + ", mExtras=" + this.mExtras + '}';
    }

    public static LinkConnectionStatus newFailedConnectionStatus(int failureCode, @Nullable String errMsg) {
        Bundle extras = new Bundle();
        extras.putInt(EXTRA_ERROR_CODE, failureCode);
        extras.putString(EXTRA_ERROR_MSG, errMsg);
        return new LinkConnectionStatus(FAILED, extras);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FailureCode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface StatusCode {
    }
}

