/*
 * Decompiled with CFR 0.152.
 */
package com.o3dr.services.android.lib.drone.mission.item.spatial;

import android.os.Parcel;
import android.os.Parcelable;
import com.o3dr.services.android.lib.drone.mission.MissionItemType;
import com.o3dr.services.android.lib.drone.mission.item.MissionItem;
import com.o3dr.services.android.lib.drone.mission.item.spatial.BaseSpatialItem;

public class Waypoint
extends BaseSpatialItem
implements Parcelable {
    private double delay;
    private double acceptanceRadius;
    private double yawAngle;
    private double orbitalRadius;
    private boolean orbitCCW;
    public static final Parcelable.Creator<Waypoint> CREATOR = new Parcelable.Creator<Waypoint>(){

        public Waypoint createFromParcel(Parcel source) {
            return new Waypoint(source);
        }

        public Waypoint[] newArray(int size) {
            return new Waypoint[size];
        }
    };

    public Waypoint() {
        super(MissionItemType.WAYPOINT);
    }

    public Waypoint(Waypoint copy) {
        super(copy);
        this.delay = copy.delay;
        this.acceptanceRadius = copy.acceptanceRadius;
        this.yawAngle = copy.yawAngle;
        this.orbitalRadius = copy.orbitalRadius;
        this.orbitCCW = copy.orbitCCW;
    }

    public double getDelay() {
        return this.delay;
    }

    public void setDelay(double delay) {
        this.delay = delay;
    }

    public double getAcceptanceRadius() {
        return this.acceptanceRadius;
    }

    public void setAcceptanceRadius(double acceptanceRadius) {
        this.acceptanceRadius = acceptanceRadius;
    }

    public double getYawAngle() {
        return this.yawAngle;
    }

    public void setYawAngle(double yawAngle) {
        this.yawAngle = yawAngle;
    }

    public double getOrbitalRadius() {
        return this.orbitalRadius;
    }

    public void setOrbitalRadius(double orbitalRadius) {
        this.orbitalRadius = orbitalRadius;
    }

    public boolean isOrbitCCW() {
        return this.orbitCCW;
    }

    public void setOrbitCCW(boolean orbitCCW) {
        this.orbitCCW = orbitCCW;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeDouble(this.delay);
        dest.writeDouble(this.acceptanceRadius);
        dest.writeDouble(this.yawAngle);
        dest.writeDouble(this.orbitalRadius);
        dest.writeByte(this.orbitCCW ? (byte)1 : 0);
    }

    private Waypoint(Parcel in) {
        super(in);
        this.delay = in.readDouble();
        this.acceptanceRadius = in.readDouble();
        this.yawAngle = in.readDouble();
        this.orbitalRadius = in.readDouble();
        this.orbitCCW = in.readByte() != 0;
    }

    @Override
    public String toString() {
        return "Waypoint{acceptanceRadius=" + this.acceptanceRadius + ", delay=" + this.delay + ", yawAngle=" + this.yawAngle + ", orbitalRadius=" + this.orbitalRadius + ", orbitCCW=" + this.orbitCCW + ", " + super.toString() + '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Waypoint)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Waypoint waypoint = (Waypoint)o;
        if (Double.compare(waypoint.delay, this.delay) != 0) {
            return false;
        }
        if (Double.compare(waypoint.acceptanceRadius, this.acceptanceRadius) != 0) {
            return false;
        }
        if (Double.compare(waypoint.yawAngle, this.yawAngle) != 0) {
            return false;
        }
        if (Double.compare(waypoint.orbitalRadius, this.orbitalRadius) != 0) {
            return false;
        }
        return this.orbitCCW == waypoint.orbitCCW;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        long temp = Double.doubleToLongBits(this.delay);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.acceptanceRadius);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.yawAngle);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.orbitalRadius);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.orbitCCW ? 1 : 0);
        return result;
    }

    @Override
    public MissionItem clone() {
        return new Waypoint(this);
    }
}

