/*
 * Decompiled with CFR 0.152.
 */
package com.o3dr.services.android.lib.drone.companion.solo.tlv;

import android.os.Parcel;
import android.os.Parcelable;
import com.o3dr.services.android.lib.drone.companion.solo.tlv.TLVPacket;
import java.nio.ByteBuffer;

public class SoloPanoOptions
extends TLVPacket {
    public static final int MESSAGE_LENGTH = 12;
    private static final int PANO_ON_VALUE = 1;
    private static final int PANO_OFF_VALUE = 0;
    private boolean isRunning;
    public static final int PANO_PREFERENCE_CYLINDRICAL = 0;
    public static final int PANO_PREFERENCE_SPHERICAL = 1;
    public static final int PANO_PREFERENCE_VIDEO = 2;
    @PanoPreference
    private int panoPreference;
    private short panAngle;
    private float degreesPerSecondYawSpeed;
    private float cameraFOV;
    public static final Parcelable.Creator<SoloPanoOptions> CREATOR = new Parcelable.Creator<SoloPanoOptions>(){

        public SoloPanoOptions createFromParcel(Parcel source) {
            return new SoloPanoOptions(source);
        }

        public SoloPanoOptions[] newArray(int size) {
            return new SoloPanoOptions[size];
        }
    };

    public boolean isRunning() {
        return this.isRunning;
    }

    public void setRunning(boolean running) {
        this.isRunning = running;
    }

    @PanoPreference
    public int getPanoPreference() {
        return this.panoPreference;
    }

    public void setPanoPreference(@PanoPreference int panoPreference) {
        this.panoPreference = panoPreference;
    }

    public short getPanAngle() {
        return this.panAngle;
    }

    public void setPanAngle(short panAngle) {
        this.panAngle = panAngle;
    }

    public float getDegreesPerSecondYawSpeed() {
        return this.degreesPerSecondYawSpeed;
    }

    public void setDegreesPerSecondYawSpeed(float degreesPerSecondYawSpeed) {
        this.degreesPerSecondYawSpeed = degreesPerSecondYawSpeed;
    }

    public float getCameraFOV() {
        return this.cameraFOV;
    }

    public void setCameraFOV(float cameraFOV) {
        this.cameraFOV = cameraFOV;
    }

    public SoloPanoOptions(int panoPreference, boolean isRunning, short panAngle, float degreesPerSecondYawSpeed, float cameraFOV) {
        super(22, 12);
        this.panoPreference = panoPreference;
        this.isRunning = isRunning;
        this.panAngle = panAngle;
        this.degreesPerSecondYawSpeed = degreesPerSecondYawSpeed;
        this.cameraFOV = cameraFOV;
    }

    SoloPanoOptions(ByteBuffer buffer) {
        this(buffer.get(), buffer.get() == 1, buffer.getShort(), buffer.getFloat(), buffer.getFloat());
    }

    @Override
    protected void getMessageValue(ByteBuffer valueCarrier) {
        valueCarrier.put((byte)this.panoPreference);
        valueCarrier.put((byte)(this.isRunning ? 1 : 0));
        valueCarrier.putShort(this.panAngle);
        valueCarrier.putFloat(this.degreesPerSecondYawSpeed);
        valueCarrier.putFloat(this.cameraFOV);
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeByte((byte)this.panoPreference);
        dest.writeByte(this.isRunning ? (byte)1 : 0);
        dest.writeInt((int)this.panAngle);
        dest.writeFloat(this.degreesPerSecondYawSpeed);
        dest.writeFloat(this.cameraFOV);
    }

    protected SoloPanoOptions(Parcel in) {
        super(in);
        byte panoPreference = in.readByte();
        this.panoPreference = panoPreference;
        this.isRunning = in.readByte() != 0;
        this.panAngle = (short)in.readInt();
        this.degreesPerSecondYawSpeed = in.readFloat();
        this.cameraFOV = in.readFloat();
    }

    @Override
    public String toString() {
        return "SoloPanoOptions{panoPreference=" + this.panoPreference + "isRunning=" + this.isRunning + "panAngle=" + this.panAngle + "degreesPerSecondYawSpeed=" + this.degreesPerSecondYawSpeed + "cameraFOV=" + this.cameraFOV + '}';
    }

    public static @interface PanoPreference {
    }
}

