/*
 * Decompiled with CFR 0.152.
 */
package com.o3dr.android.client.utils.geotag;

import android.os.AsyncTask;
import com.o3dr.android.client.utils.data.tlog.TLogParser;
import com.o3dr.android.client.utils.geotag.GeoTagUtils;
import com.o3dr.android.client.utils.geotag.SimpleGeoTagAlgorithm;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public abstract class GeoTagAsyncTask
extends AsyncTask<Void, Integer, GeoTagUtils.ResultObject> {
    private final File rootDir;
    private final List<TLogParser.Event> events;
    private final ArrayList<File> photos;
    private final GeoTagAlgorithm geoTagAlg;
    private final GeoTagUtils.GeoTagListener listener = new GeoTagUtils.GeoTagListener(){

        @Override
        public void onProgress(int numProcessed, int numTotal) {
            GeoTagAsyncTask.this.publishProgress(new Integer[]{numProcessed, numTotal});
        }
    };

    public GeoTagAsyncTask(File rootDir, List<TLogParser.Event> events, ArrayList<File> photos) {
        this(rootDir, events, photos, new SimpleGeoTagAlgorithm());
    }

    public GeoTagAsyncTask(File rootDir, List<TLogParser.Event> events, ArrayList<File> photos, GeoTagAlgorithm geotagAlg) {
        this.rootDir = rootDir;
        this.events = events;
        this.photos = photos;
        this.geoTagAlg = geotagAlg;
    }

    protected GeoTagUtils.ResultObject doInBackground(Void ... params) {
        if (this.isCancelled()) {
            return new GeoTagUtils.ResultObject();
        }
        return GeoTagUtils.geotag(this.rootDir, this.events, this.photos, this.geoTagAlg, this.listener);
    }

    protected final void onPostExecute(GeoTagUtils.ResultObject resultObject) {
        if (resultObject.didSucceed()) {
            this.onResult(resultObject.getGeoTaggedPhotos(), resultObject.getFailedFiles());
        } else {
            this.onFailed(resultObject.getException());
        }
    }

    protected final void onProgressUpdate(Integer ... values) {
        this.onProgress(values[0], values[1]);
    }

    protected final void onCancelled(GeoTagUtils.ResultObject resultObject) {
        this.onResult(resultObject.getGeoTaggedPhotos(), resultObject.getFailedFiles());
    }

    public abstract void onResult(HashMap<File, File> var1, HashMap<File, Exception> var2);

    public abstract void onProgress(int var1, int var2);

    public abstract void onFailed(Exception var1);

    protected static interface GeoTagAlgorithm {
        public HashMap<TLogParser.Event, File> match(List<TLogParser.Event> var1, ArrayList<File> var2);
    }
}

