/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.utils.file.IO;

import android.util.Xml;
import java.io.IOException;
import java.io.InputStream;
import org.droidplanner.services.android.impl.core.survey.CameraInfo;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class CameraInfoReader {
    private XmlPullParser parser;
    private CameraInfo cameraInfo = new CameraInfo();

    public void openFile(InputStream inputStream) throws Exception {
        this.parse(inputStream);
        inputStream.close();
    }

    public CameraInfo getCameraInfo() {
        return this.cameraInfo;
    }

    public void parse(InputStream in) throws XmlPullParserException, IOException {
        this.parser = Xml.newPullParser();
        this.parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", false);
        this.parser.setInput(in, null);
        this.parser.nextTag();
        this.readCameraInfo();
    }

    private void readCameraInfo() throws XmlPullParserException, IOException {
        this.parser.require(2, null, "cameraInfo");
        while (this.parser.next() != 3) {
            if (this.parser.getEventType() != 2) continue;
            String name = this.parser.getName();
            if (name.equals("SensorWidth")) {
                this.cameraInfo.sensorWidth = this.readDouble("SensorWidth");
                continue;
            }
            if (name.equals("SensorHeight")) {
                this.cameraInfo.sensorHeight = this.readDouble("SensorHeight");
                continue;
            }
            if (name.equals("SensorResolution")) {
                this.cameraInfo.sensorResolution = this.readDouble("SensorResolution");
                continue;
            }
            if (name.equals("FocalLength")) {
                this.cameraInfo.focalLength = this.readDouble("FocalLength");
                continue;
            }
            if (name.equals("Overlap")) {
                this.cameraInfo.overlap = this.readDouble("Overlap");
                continue;
            }
            if (name.equals("Sidelap")) {
                this.cameraInfo.sidelap = this.readDouble("Sidelap");
                continue;
            }
            if (name.equals("Name")) {
                this.cameraInfo.name = this.readString("Name");
                continue;
            }
            if (name.equals("Orientation")) {
                this.cameraInfo.isInLandscapeOrientation = !this.readText().equals("Portrait");
                continue;
            }
            this.skip();
        }
    }

    private String readString(String entry) throws IOException, XmlPullParserException {
        this.parser.require(2, null, entry);
        String value = this.readText();
        this.parser.require(3, null, entry);
        return value;
    }

    private Double readDouble(String entry) throws IOException, XmlPullParserException {
        this.parser.require(2, null, entry);
        Double value = Double.valueOf(this.readText());
        this.parser.require(3, null, entry);
        return value;
    }

    private String readText() throws IOException, XmlPullParserException {
        String result = "";
        if (this.parser.next() == 4) {
            result = this.parser.getText();
            this.parser.nextTag();
        }
        return result;
    }

    private void skip() throws XmlPullParserException, IOException {
        if (this.parser.getEventType() != 2) {
            throw new IllegalStateException();
        }
        int depth = 1;
        while (depth != 0) {
            switch (this.parser.next()) {
                case 3: {
                    --depth;
                    break;
                }
                case 2: {
                    ++depth;
                }
            }
        }
    }
}

